package org.wildfly.swarm.config.microprofile.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Config Source Provider
 */
@Address("/subsystem=microprofile-config/config-source-provider=*")
@ResourceType("config-source-provider")
public class ConfigSourceProvider<T extends ConfigSourceProvider<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Class of the ConfigSourceProvider to load")
	private Map attributeClass;

	public ConfigSourceProvider(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class of the ConfigSourceProvider to load
	 */
	@ModelNodeBinding(detypedName = "class")
	public Map attributeClass() {
		return this.attributeClass;
	}

	/**
	 * Class of the ConfigSourceProvider to load
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(java.util.Map value) {
		Object oldValue = this.attributeClass;
		this.attributeClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeClass", oldValue, value);
		return (T) this;
	}

	/**
	 * Class of the ConfigSourceProvider to load
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(java.lang.String key, java.lang.Object value) {
		if (this.attributeClass == null) {
			this.attributeClass = new java.util.HashMap<>();
		}
		this.attributeClass.put(key, value);
		return (T) this;
	}
}