/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.microprofile.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=microprofile-config/config-source=*")
@ResourceType(value="config-source")
public class ConfigSource<T extends ConfigSource<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Class of the config source to load")
    private Map attributeClass;
    @AttributeDocumentation(value="Directory that is scanned to config properties for this config source (file names are key, file content are value)")
    private String dir;
    @AttributeDocumentation(value="Ordinal value for the config source")
    private Integer ordinal;
    @AttributeDocumentation(value="Properties configured for this config source")
    private Map properties;

    public ConfigSource(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="class")
    public Map attributeClass() {
        return this.attributeClass;
    }

    public T attributeClass(Map value) {
        Map oldValue = this.attributeClass;
        this.attributeClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeClass", oldValue, value);
        }
        return (T)this;
    }

    public T attributeClass(String key, Object value) {
        if (this.attributeClass == null) {
            this.attributeClass = new HashMap();
        }
        this.attributeClass.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="dir")
    public String dir() {
        return this.dir;
    }

    public T dir(String value) {
        String oldValue = this.dir;
        this.dir = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dir", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ordinal")
    public Integer ordinal() {
        return this.ordinal;
    }

    public T ordinal(Integer value) {
        Integer oldValue = this.ordinal;
        this.ordinal = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ordinal", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }
}

