package org.wildfly.swarm.config.microprofile.config;

import org.wildfly.swarm.config.microprofile.config.ConfigSource;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConfigSourceConsumer<T extends ConfigSource<T>> {

	/**
	 * Configure a pre-constructed instance of ConfigSource resource
	 * 
	 * @parameter Instance of ConfigSource to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigSourceConsumer<T> andThen(ConfigSourceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}