package org.wildfly.swarm.config;

import org.wildfly.swarm.config.MicroprofileConfig;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface MicroprofileConfigConsumer<T extends MicroprofileConfig<T>> {

	/**
	 * Configure a pre-constructed instance of MicroprofileConfig resource
	 * 
	 * @parameter Instance of MicroprofileConfig to configure
	 * @return nothing
	 */
	void accept(T value);

	default MicroprofileConfigConsumer<T> andThen(
			MicroprofileConfigConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}