/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.config.example;

import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.wildfly.swarm.microprofile.config.example.Duck;

@Path(value="/hello")
public class HelloWorldEndpoint {
    @Inject
    Config config;
    @Inject
    @ConfigProperty(name="BAR", defaultValue="my BAR property comes from the code")
    String bar;
    @Inject
    @ConfigProperty(name="BOOL_PROP", defaultValue="no")
    boolean boolProp;
    @Inject
    @ConfigProperty(name="DUCK")
    Optional<Duck> duck;

    @GET
    @Produces(value={"text/plain"})
    public Response doGet() {
        Optional foo = this.config.getOptionalValue("FOO", String.class);
        StringBuilder text = new StringBuilder();
        text.append("FOO property = " + foo + "\n");
        text.append("BAR property = " + this.bar + "\n");
        text.append("BOOL_PROP property = " + this.boolProp + "\n");
        text.append("DUCK property =" + ((Duck)this.duck.get()).getName());
        return Response.ok((Object)text).build();
    }
}

