/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.clustering.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.wildfly.swarm.clustering.Channel;
import org.wildfly.swarm.clustering.ClusteringFraction;
import org.wildfly.swarm.clustering.Protocol;
import org.wildfly.swarm.clustering.SocketBindingProtocol;
import org.wildfly.swarm.clustering.Stack;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;

public class ClusteringConfiguration
extends AbstractServerConfiguration<ClusteringFraction> {
    public ClusteringConfiguration() {
        super(ClusteringFraction.class);
    }

    public ClusteringFraction defaultFraction() {
        return new ClusteringFraction().defaultChannel(new Channel("swarm-clustering")).defaultStack(Stack.defaultUDPStack());
    }

    public List<ModelNode> getList(ClusteringFraction fraction) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode node = new ModelNode();
        node.get("address").set("extension", "org.jboss.as.clustering.jgroups");
        node.get("operation").set("add");
        list.add(node);
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"jgroups")});
        node = new ModelNode();
        node.get("address").set(address.toModelNode());
        node.get("operation").set("add");
        if (fraction.defaultChannel() != null) {
            node.get("default-channel").set(fraction.defaultChannel().name());
        }
        if (fraction.defaultStack() != null) {
            node.get("default-stack").set(fraction.defaultStack().name());
        }
        list.add(node);
        for (Channel channel : fraction.channels()) {
            node = new ModelNode();
            node.get("address").set(address.append("channel", channel.name()).toModelNode());
            node.get("operation").set("add");
            list.add(node);
        }
        for (Stack stack : fraction.stacks()) {
            PathAddress stackAddr = address.append("stack", stack.name());
            node = new ModelNode();
            node.get("address").set(stackAddr.toModelNode());
            node.get("operation").set("add");
            list.add(node);
            node = new ModelNode();
            node.get("address").set(stackAddr.append("transport", stack.transport().name()).toModelNode());
            node.get("operation").set("add");
            node.get("socket-binding").set(stack.transport().socketBinding());
            for (Map.Entry entry : stack.transport().properties().entrySet()) {
                node.get((String)entry.getKey()).set(new ValueExpression((String)entry.getValue()));
            }
            list.add(node);
            for (Protocol protocol : stack.protocols()) {
                node = new ModelNode();
                node.get("address").set(stackAddr.append("protocol", protocol.name()).toModelNode());
                node.get("operation").set("add");
                if (protocol instanceof SocketBindingProtocol) {
                    node.get("socket-binding").set(((SocketBindingProtocol)protocol).socketBinding());
                }
                for (Map.Entry entry : protocol.properties().entrySet()) {
                    node.get((String)entry.getKey()).set(new ValueExpression((String)entry.getValue()));
                }
                list.add(node);
            }
        }
        return list;
    }
}

