/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.LogManager;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.selfcontained.ContentProvider;
import org.jboss.as.server.SelfContainedContainer;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.vfs.TempFileProvider;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Deployer;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.RuntimeModuleProvider;
import org.wildfly.swarm.container.Server;
import org.wildfly.swarm.container.SocketBinding;
import org.wildfly.swarm.container.SocketBindingGroup;
import org.wildfly.swarm.container.runtime.RuntimeDeployer;
import org.wildfly.swarm.container.runtime.ServerConfiguration;
import org.wildfly.swarm.container.runtime.SimpleContentProvider;

public class RuntimeServer
implements Server {
    private SelfContainedContainer container = new SelfContainedContainer();
    private SimpleContentProvider contentProvider = new SimpleContentProvider();
    private ServiceContainer serviceContainer;
    private ModelControllerClient client;
    private RuntimeDeployer deployer;
    private Map<Class<? extends Fraction>, ServerConfiguration> configByFractionType = new ConcurrentHashMap<Class<? extends Fraction>, ServerConfiguration>();
    private List<ServerConfiguration> configList = new ArrayList<ServerConfiguration>();

    public RuntimeServer() {
        try {
            Module loggingModule = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.logging", (String)"runtime"));
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)loggingModule.getClassLoader());
                System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                LogManager.getLogManager();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        catch (ModuleLoadException e) {
            System.err.println("[WARN] wildfly-swarm-logging not available, logging will not be configured");
        }
    }

    public Deployer start(final Container config) throws Exception {
        this.loadFractionConfigurations();
        this.applyDefaults(config);
        List<ModelNode> list = this.getList(config);
        list.sort(new ExtensionOpPriorityComparator());
        Thread.currentThread().setContextClassLoader(RuntimeServer.class.getClassLoader());
        UUID grist = UUID.randomUUID();
        String tmpDir = System.getProperty("java.io.tmpdir");
        System.err.println("tmpDir: " + tmpDir);
        Path gristedTmp = Paths.get(tmpDir, new String[0]).resolve("wildfly-swarm-" + grist);
        System.setProperty("jboss.server.temp.dir", gristedTmp.toString());
        ScheduledExecutorService tempFileExecutor = Executors.newSingleThreadScheduledExecutor();
        final TempFileProvider tempFileProvider = TempFileProvider.create((String)"wildfly-swarm", (ScheduledExecutorService)tempFileExecutor);
        ArrayList<ServiceActivator> activators = new ArrayList<ServiceActivator>();
        activators.add(new ServiceActivator(){

            public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
                context.getServiceTarget().addService(ServiceName.of((String[])new String[]{"wildfly", "swarm", "temp-provider"}), (Service)new ValueService((Value)new ImmediateValue((Object)tempFileProvider))).install();
                context.getServiceTarget().addService(ServiceName.of((String[])new String[]{"wildfly", "swarm", "main-args"}), (Service)new ValueService((Value)new ImmediateValue((Object)config.getArgs()))).install();
            }
        });
        for (ServerConfiguration eachConfig : this.configList) {
            boolean found = false;
            for (Fraction eachFraction : config.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                found = true;
                activators.addAll(eachConfig.getServiceActivators(eachFraction));
                break;
            }
            if (found || eachConfig.isIgnorable()) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
        this.serviceContainer = this.container.start(list, (ContentProvider)this.contentProvider, activators);
        ModelController controller = (ModelController)this.serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER).getValue();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.client = controller.createClient((Executor)executor);
        this.deployer = new RuntimeDeployer(this.configList, this.client, this.contentProvider, tempFileProvider);
        return this.deployer;
    }

    public void stop() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.serviceContainer.addTerminateListener(new ServiceContainer.TerminateListener(){

            public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                latch.countDown();
            }
        });
        this.serviceContainer.shutdown();
        latch.await();
        this.deployer.stop();
        this.serviceContainer = null;
        this.client = null;
        this.deployer = null;
    }

    public Set<Class<? extends Fraction>> getFractionTypes() {
        return this.configByFractionType.keySet();
    }

    public Fraction createDefaultFor(Class<? extends Fraction> fractionClazz) {
        return this.configByFractionType.get(fractionClazz).defaultFraction();
    }

    private void applyDefaults(Container config) throws Exception {
        config.applyFractionDefaults((Server)this);
        this.applyInterfaceDefaults(config);
        this.applySocketBindingGroupDefaults(config);
    }

    private void applyInterfaceDefaults(Container config) {
        if (config.ifaces().isEmpty()) {
            config.iface("public", "${jboss.bind.address:0.0.0.0}");
        }
    }

    private void applySocketBindingGroupDefaults(Container config) {
        if (config.socketBindingGroups().isEmpty()) {
            config.socketBindingGroup(new SocketBindingGroup("default-sockets", "public", "${jboss.socket.binding.port-offset:0}"));
        }
        Set groupNames = config.socketBindings().keySet();
        for (String each : groupNames) {
            List bindings = (List)config.socketBindings().get(each);
            SocketBindingGroup group = config.getSocketBindingGroup(each);
            if (group == null) {
                throw new RuntimeException("No socket-binding-group for '" + each + "'");
            }
            for (SocketBinding binding : bindings) {
                group.socketBinding(binding);
            }
        }
    }

    private void loadFractionConfigurations() throws Exception {
        Module m1 = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"swarm.application"));
        ServiceLoader<RuntimeModuleProvider> providerLoader = m1.loadService(RuntimeModuleProvider.class);
        Iterator<Object> providerIter = providerLoader.iterator();
        if (!providerIter.hasNext()) {
            providerLoader = ServiceLoader.load(RuntimeModuleProvider.class, ClassLoader.getSystemClassLoader());
            providerIter = providerLoader.iterator();
        }
        while (providerIter.hasNext()) {
            RuntimeModuleProvider provider = (RuntimeModuleProvider)providerIter.next();
            Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)provider.getModuleName(), (String)provider.getSlotName()));
            ServiceLoader configLoaders = module.loadService(ServerConfiguration.class);
            for (ServerConfiguration serverConfig : configLoaders) {
                this.configByFractionType.put(serverConfig.getType(), serverConfig);
                this.configList.add(serverConfig);
            }
        }
    }

    private List<ModelNode> getList(Container config) throws ModuleLoadException {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        this.configureInterfaces(config, list);
        this.configureSocketBindingGroups(config, list);
        this.configureFractions(config, list);
        return list;
    }

    private void configureInterfaces(Container config, List<ModelNode> list) {
        List ifaces = config.ifaces();
        for (Interface each : ifaces) {
            this.configureInterface(each, list);
        }
    }

    private void configureInterface(Interface iface, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set("interface", iface.getName());
        node.get("inet-address").set(new ValueExpression(iface.getExpression()));
        list.add(node);
    }

    private void configureSocketBindingGroups(Container config, List<ModelNode> list) {
        List groups = config.socketBindingGroups();
        for (SocketBindingGroup each : groups) {
            this.configureSocketBindingGroup(each, list);
        }
    }

    private void configureSocketBindingGroup(SocketBindingGroup group, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        PathAddress address = PathAddress.pathAddress((String)"socket-binding-group", (String)group.name());
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode());
        node.get("default-interface").set(group.defaultInterface());
        node.get("port-offset").set(new ValueExpression(group.portOffsetExpression()));
        list.add(node);
        this.configureSocketBindings(address, group, list);
    }

    private void configureSocketBindings(PathAddress address, SocketBindingGroup group, List<ModelNode> list) {
        List bindings = group.socketBindings();
        for (SocketBinding each : bindings) {
            this.configureSocketBinding(address, each, list);
        }
    }

    private void configureSocketBinding(PathAddress address, SocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("port").set(new ValueExpression(binding.portExpression()));
        if (binding.multicastAddress() != null) {
            node.get("multicast-address").set(binding.multicastAddress());
        }
        if (binding.multicastPortExpression() != null) {
            node.get("multicast-port").set(new ValueExpression(binding.multicastPortExpression()));
        }
        list.add(node);
    }

    private void configureFractions(Container config, List<ModelNode> list) throws ModuleLoadException {
        for (ServerConfiguration eachConfig : this.configList) {
            boolean found = false;
            for (Fraction eachFraction : config.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                found = true;
                list.addAll(eachConfig.getList(eachFraction));
                break;
            }
            if (found || eachConfig.isIgnorable()) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
    }

    private static class ExtensionOpPriorityComparator
    implements Comparator<ModelNode> {
        private ExtensionOpPriorityComparator() {
        }

        @Override
        public int compare(ModelNode left, ModelNode right) {
            PathAddress leftAddr = PathAddress.pathAddress((ModelNode)left.get("address"));
            PathAddress rightAddr = PathAddress.pathAddress((ModelNode)right.get("address"));
            String leftOpName = left.require("operation").asString();
            String rightOpName = left.require("operation").asString();
            if (leftAddr.size() == 1 && leftAddr.getElement(0).getKey().equals("extension") && leftOpName.equals("add")) {
                return -1;
            }
            if (rightAddr.size() == 1 && rightAddr.getElement(0).getKey().equals("extension") && rightOpName.equals("add")) {
                return 1;
            }
            return 0;
        }
    }
}

