/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.beanvalidation;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.jboss.as.ee.beanvalidation.WildFlyProviderResolver;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LazyValidatorFactory
implements ValidatorFactory {
    private final ClassLoader classLoader;
    private volatile ValidatorFactory delegate;

    public LazyValidatorFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getDelegate() {
        ValidatorFactory result = this.delegate;
        if (result == null) {
            LazyValidatorFactory lazyValidatorFactory = this;
            synchronized (lazyValidatorFactory) {
                result = this.delegate;
                if (result == null) {
                    this.delegate = result = this.initFactory();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDelegate(ValidatorFactory validatorFactory) {
        LazyValidatorFactory lazyValidatorFactory = this;
        synchronized (lazyValidatorFactory) {
            this.delegate = validatorFactory;
        }
    }

    public Validator getValidator() {
        return this.getDelegate().getValidator();
    }

    private ValidatorFactory initFactory() {
        ClassLoader oldTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            ValidatorFactory validatorFactory = Validation.byDefaultProvider().providerResolver((ValidationProviderResolver)new WildFlyProviderResolver()).configure().buildValidatorFactory();
            return validatorFactory;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    public ValidatorContext usingContext() {
        ClassLoader oldTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            ValidatorContext validatorContext = this.getDelegate().usingContext();
            return validatorContext;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.getDelegate().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.getDelegate().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getDelegate().getConstraintValidatorFactory();
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.getDelegate().getParameterNameProvider();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.getDelegate().unwrap(clazz);
    }

    public void close() {
        this.getDelegate().close();
    }
}

