/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBClientTransactionContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.UserTransactionID;

public final class EJBClientUserTransactionContext
extends EJBClientTransactionContext {
    static final EJBClientUserTransactionContext INSTANCE = new EJBClientUserTransactionContext();
    private static final ThreadLocal<State> CURRENT_TRANSACTION_STATE = new ThreadLocal();
    private static final AtomicInteger idCounter = new AtomicInteger(new Random().nextInt());

    @Override
    protected UserTransactionID getAssociatedTransactionID(EJBClientInvocationContext invocationContext) {
        State state = CURRENT_TRANSACTION_STATE.get();
        return state == null ? null : state.currentId;
    }

    @Override
    protected String getTransactionNode() {
        State state = CURRENT_TRANSACTION_STATE.get();
        UserTransactionID id = state == null ? null : state.currentId;
        return id == null ? null : id.getNodeName();
    }

    @Override
    protected UserTransaction getUserTransaction(String nodeName) {
        return new UserTransactionImpl(nodeName);
    }

    class UserTransactionImpl
    implements UserTransaction {
        private final String nodeName;

        UserTransactionImpl(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public void begin() throws NotSupportedException, SystemException {
            UserTransactionID transactionID;
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            if (state == null) {
                state = new State();
                CURRENT_TRANSACTION_STATE.set(state);
            }
            if (state.currentId != null) {
                throw Logs.MAIN.txAlreadyAssociatedWithThread();
            }
            state.currentId = transactionID = new UserTransactionID(this.nodeName, idCounter.getAndAdd(127));
            state.status = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            if (state == null || state.currentId == null) {
                throw Logs.MAIN.noTxAssociatedWithThread();
            }
            if (state.status != 0 && state.status != 1) {
                throw Logs.MAIN.txNotActiveForThread();
            }
            UserTransactionID transactionID = state.currentId;
            try {
                EJBClientContext clientContext = EJBClientContext.requireCurrent();
                EJBReceiverContext receiverContext = clientContext.requireNodeEJBReceiverContext(this.nodeName);
                EJBReceiver receiver = receiverContext.getReceiver();
                if (state.status == 1) {
                    state.status = 9;
                    try {
                        receiver.sendRollback(receiverContext, transactionID);
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    throw new RollbackException("Transaction marked for rollback only");
                }
                state.status = 8;
                try {
                    receiver.sendCommit(receiverContext, transactionID, true);
                }
                catch (XAException e) {
                    if (e.errorCode >= 100 && e.errorCode <= 107) {
                        throw new RollbackException(e.getMessage());
                    }
                    if (e.errorCode == 5) {
                        throw new HeuristicMixedException(e.getMessage());
                    }
                    if (e.errorCode == 6) {
                        throw new HeuristicRollbackException(e.getMessage());
                    }
                    throw new SystemException(e.getMessage());
                }
            }
            finally {
                state.currentId = null;
                state.status = 6;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            if (state == null || state.currentId == null) {
                throw Logs.MAIN.noTxAssociatedWithThread();
            }
            if (state.status != 0 && state.status != 1) {
                throw Logs.MAIN.txNotActiveForThread();
            }
            UserTransactionID transactionID = state.currentId;
            try {
                EJBClientContext clientContext = EJBClientContext.requireCurrent();
                EJBReceiverContext receiverContext = clientContext.requireNodeEJBReceiverContext(this.nodeName);
                EJBReceiver receiver = receiverContext.getReceiver();
                state.status = 9;
                try {
                    receiver.sendRollback(receiverContext, transactionID);
                }
                catch (XAException e) {
                    throw new SystemException(e.getMessage());
                }
            }
            finally {
                state.currentId = null;
                state.status = 6;
            }
        }

        @Override
        public void setRollbackOnly() throws IllegalStateException, SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            if (state != null) {
                switch (state.status) {
                    case 1: 
                    case 4: 
                    case 9: {
                        return;
                    }
                    case 0: {
                        state.status = 1;
                        return;
                    }
                }
            }
            throw new IllegalStateException("Transaction not active");
        }

        @Override
        public int getStatus() throws SystemException {
            State state = (State)CURRENT_TRANSACTION_STATE.get();
            return state == null ? 6 : state.status;
        }

        @Override
        public void setTransactionTimeout(int seconds) throws SystemException {
            State state;
            if (seconds < 0) {
                seconds = 0;
            }
            if ((state = (State)CURRENT_TRANSACTION_STATE.get()) == null) {
                state = new State();
                CURRENT_TRANSACTION_STATE.set(state);
            }
        }
    }

    static class State {
        UserTransactionID currentId;
        int status = 6;

        State() {
        }
    }
}

