/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;

public final class FlatNavigableMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V> {
    private final Comparator<? super K> comparator;
    private final List<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
    private final Set<Map.Entry<K, V>> entrySet = new AbstractSet<Map.Entry<K, V>>(){

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return FlatNavigableMap.this.entries.iterator();
        }

        @Override
        public int size() {
            return FlatNavigableMap.this.entries.size();
        }
    };

    @Override
    public V put(K key, V value) {
        this.entries.add(new EntryImpl<K, V>(key, value));
        return null;
    }

    public FlatNavigableMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K lowerKey(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K floorKey(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K ceilingKey(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K higherKey(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K firstKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public K lastKey() {
        throw new UnsupportedOperationException();
    }

    static final class EntryImpl<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        EntryImpl(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V setValue(V value) {
            try {
                V v = this.value;
                return v;
            }
            finally {
                this.value = value;
            }
        }

        private static int hashOf(Object obj) {
            return obj == null ? 0 : obj.hashCode();
        }

        private static boolean equals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }

        @Override
        public final int hashCode() {
            return EntryImpl.hashOf(this.getKey()) ^ EntryImpl.hashOf(this.getValue());
        }

        @Override
        public final boolean equals(Object obj) {
            return obj instanceof Map.Entry && this.equals((Map.Entry)obj);
        }

        public final boolean equals(Map.Entry<?, ?> obj) {
            return obj != null && EntryImpl.equals(this.getKey(), obj.getKey()) && EntryImpl.equals(this.getValue(), obj.getValue());
        }

        public String toString() {
            return String.format("{%s=>%s}", this.getKey(), this.getValue());
        }
    }
}

