/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateSharedQueueMessage
extends PacketImpl {
    private SimpleString address;
    private SimpleString queueName;
    private SimpleString filterString;
    private boolean durable;
    private boolean requiresResponse;

    public CreateSharedQueueMessage(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean requiresResponse) {
        this();
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.requiresResponse = requiresResponse;
    }

    public CreateSharedQueueMessage() {
        super((byte)36);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", address=" + this.address);
        buff.append(", queueName=" + this.queueName);
        buff.append(", filterString=" + this.filterString);
        buff.append(", durable=" + this.filterString);
        buff.append("]");
        return buff.toString();
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public void setAddress(SimpleString address) {
        this.address = address;
    }

    public void setQueueName(SimpleString queueName) {
        this.queueName = queueName;
    }

    public void setFilterString(SimpleString filterString) {
        this.filterString = filterString;
    }

    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.durable);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.address = buffer.readSimpleString();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.durable = buffer.readBoolean();
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.durable ? 1231 : 1237);
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSharedQueueMessage)) {
            return false;
        }
        CreateSharedQueueMessage other = (CreateSharedQueueMessage)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.durable != other.durable) {
            return false;
        }
        return this.requiresResponse == other.requiresResponse;
    }
}

