/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import javax.management.ObjectName;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;

public final class ObjectNameBuilder {
    public static final ObjectNameBuilder DEFAULT = new ObjectNameBuilder(ActiveMQDefaultConfiguration.getDefaultJmxDomain(), "localhost", true);
    static final String JMS_MODULE = "JMS";
    static final String CORE_MODULE = "Core";
    private final String domain;
    private String brokerName;
    private final boolean jmxUseBrokerName;

    public static ObjectNameBuilder create(String domain) {
        if (domain == null) {
            return new ObjectNameBuilder(ActiveMQDefaultConfiguration.getDefaultJmxDomain(), null, false);
        }
        return new ObjectNameBuilder(domain, null, false);
    }

    public static ObjectNameBuilder create(String domain, String brokerName) {
        if (domain == null) {
            return new ObjectNameBuilder(ActiveMQDefaultConfiguration.getDefaultJmxDomain(), brokerName, true);
        }
        return new ObjectNameBuilder(domain, brokerName, true);
    }

    public static ObjectNameBuilder create(String domain, String brokerName, boolean jmxUseBrokerName) {
        if (domain == null) {
            return new ObjectNameBuilder(ActiveMQDefaultConfiguration.getDefaultJmxDomain(), brokerName, jmxUseBrokerName);
        }
        return new ObjectNameBuilder(domain, brokerName, jmxUseBrokerName);
    }

    private ObjectNameBuilder(String domain, String brokerName, boolean jmxUseBrokerName) {
        this.domain = domain;
        this.brokerName = brokerName;
        this.jmxUseBrokerName = jmxUseBrokerName;
    }

    public ObjectName getActiveMQServerObjectName() throws Exception {
        return ObjectName.getInstance(this.domain + ":" + this.getBrokerProperties() + "module=Core," + this.getObjectType() + "=Server");
    }

    public ObjectName getAddressObjectName(SimpleString address) throws Exception {
        return this.createObjectName(CORE_MODULE, "Address", address.toString());
    }

    public ObjectName getQueueObjectName(SimpleString address, SimpleString name) throws Exception {
        return ObjectName.getInstance(String.format("%s:" + this.getBrokerProperties() + "module=%s," + this.getObjectType() + "=%s,address=%s,name=%s", this.domain, CORE_MODULE, "Queue", ObjectName.quote(address.toString()), ObjectName.quote(name.toString())));
    }

    public ObjectName getDivertObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "Divert", name);
    }

    public ObjectName getAcceptorObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "Acceptor", name);
    }

    public ObjectName getBroadcastGroupObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "BroadcastGroup", name);
    }

    public ObjectName getBridgeObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "Bridge", name);
    }

    public ObjectName getClusterConnectionObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "ClusterConnection", name);
    }

    public ObjectName getDiscoveryGroupObjectName(String name) throws Exception {
        return this.createObjectName(CORE_MODULE, "DiscoveryGroup", name);
    }

    public ObjectName getJMSServerObjectName() throws Exception {
        return ObjectName.getInstance(this.domain + ":" + this.getBrokerProperties() + "module=JMS," + this.getObjectType() + "=Server");
    }

    public ObjectName getJMSQueueObjectName(String name) throws Exception {
        return this.createObjectName(JMS_MODULE, "Queue", name);
    }

    public ObjectName getJMSTopicObjectName(String name) throws Exception {
        return this.createObjectName(JMS_MODULE, "Topic", name);
    }

    public ObjectName getConnectionFactoryObjectName(String name) throws Exception {
        return this.createObjectName(JMS_MODULE, "ConnectionFactory", name);
    }

    private ObjectName createObjectName(String module, String type, String name) throws Exception {
        String format = String.format("%s:" + this.getBrokerProperties() + "module=%s," + this.getObjectType() + "=%s,name=%s", this.domain, module, type, ObjectName.quote(name));
        return ObjectName.getInstance(format);
    }

    private String getBrokerProperties() {
        if (this.jmxUseBrokerName && this.brokerName != null) {
            return String.format("type=Broker,brokerName=%s,", ObjectName.quote(this.brokerName));
        }
        return "";
    }

    private String getObjectType() {
        if (this.jmxUseBrokerName && this.brokerName != null) {
            return "serviceType";
        }
        return "type";
    }
}

