/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.msc.service.MSCRunnable;

class MSCExecutor {
    static final String ENABLED_PROP = "org.jboss.msc.directionalExecutor";
    private final Executor delegate;
    private final AtomicInteger outstandingCount = new AtomicInteger();
    private final List<MSCRunnable> queue = new ArrayList<MSCRunnable>();
    private static final boolean enabled = Boolean.getBoolean("org.jboss.msc.directionalExecutor");

    MSCExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(final MSCRunnable runnable) {
        int direction;
        if (!enabled || runnable.isBiDirectional()) {
            this.delegate.execute(runnable);
            return;
        }
        boolean forward = runnable.isForwardTask();
        int n = direction = forward ? 1 : -1;
        while (true) {
            int count;
            if ((count = this.outstandingCount.get()) * direction < 0) {
                MSCExecutor mSCExecutor = this;
                synchronized (mSCExecutor) {
                    if (this.outstandingCount.get() * direction < 0) {
                        this.queue.add(runnable);
                        return;
                    }
                }
            }
            int newVal = count + direction;
            if (this.outstandingCount.compareAndSet(count, newVal)) break;
        }
        final int reverse = direction * -1;
        try {
            this.delegate.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    finally {
                        MSCExecutor.this.taskComplete(reverse);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.taskComplete(reverse);
            throw e;
        }
        catch (Error e) {
            this.taskComplete(reverse);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskComplete(int reverse) {
        boolean ok;
        do {
            int count;
            int newVal;
            if ((newVal = (count = this.outstandingCount.get()) + reverse) == 0) {
                MSCExecutor mSCExecutor = this;
                synchronized (mSCExecutor) {
                    ok = this.outstandingCount.compareAndSet(count, newVal);
                    if (ok) {
                        this.runQueue();
                    }
                }
            } else {
                ok = this.outstandingCount.compareAndSet(count, newVal);
            }
        } while (!ok);
    }

    private void runQueue() {
        assert (Thread.holdsLock(this));
        final ArrayList<MSCRunnable> runnables = new ArrayList<MSCRunnable>(this.queue);
        this.queue.clear();
        this.delegate.execute(new Runnable(){

            @Override
            public void run() {
                for (MSCRunnable r : runnables) {
                    MSCExecutor.this.execute(r);
                }
            }
        });
    }
}

