/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.less;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.man.AeshFileDisplayer;
import org.aesh.command.man.FileParser;
import org.aesh.command.man.TerminalPage;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.extensions.highlight.Encoder;
import org.aesh.extensions.highlight.Scanner;
import org.aesh.extensions.highlight.Syntax;
import org.aesh.extensions.less.SimpleFileParser;
import org.aesh.io.Resource;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

@CommandDefinition(name="less", description="less is more")
public class Less
extends AeshFileDisplayer {
    @Arguments
    List<Resource> arguments;
    @Option(hasValue=false)
    private boolean color;
    private SimpleFileParser loader;

    public void setFile(File file) throws IOException {
        this.loader.setFile(file);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(filename);
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    public void setFile(InputStream inputStream, String fileName) {
        this.loader.setFile(inputStream, fileName);
    }

    @Override
    public FileParser getFileParser() {
        return this.loader;
    }

    @Override
    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == TerminalPage.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == TerminalPage.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.INVERT_BACKGROUND + "Pattern not found (press RETURN)" + "\u001b[0;39m");
        } else if (this.getSearchStatus() == TerminalPage.Search.RESULT) {
            this.writeToConsole(":");
        } else if (this.getSearchStatus() == TerminalPage.Search.NO_SEARCH) {
            if (this.isAtBottom()) {
                this.writeToConsole(ANSI.INVERT_BACKGROUND + "(END)" + "\u001b[0;39m");
            } else {
                this.writeToConsole(":");
            }
        }
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws InterruptedException {
        block8: {
            this.setCommandInvocation(commandInvocation);
            this.loader = new SimpleFileParser();
            if (this.arguments != null && this.arguments.size() > 0) {
                Resource f = this.arguments.get(0).resolve(commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory()).get(0);
                if (f.isLeaf()) {
                    try {
                        if (this.color) {
                            String content = this.readFile(f.read());
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            Syntax.builtIns();
                            Syntax.Builder.create().encoderType(Encoder.Type.TERMINAL).output(baos).scanner(Scanner.Factory.byFileName(f.getName())).execute(content);
                            this.setInput(new String(baos.toByteArray()));
                            this.afterAttach();
                            break block8;
                        }
                        this.setFile(f.read(), f.getName());
                        this.afterAttach();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (f.isDirectory()) {
                    this.getShell().writeln(f.getAbsolutePath() + ": is a directory");
                } else {
                    this.getShell().writeln(f.getAbsolutePath() + ": No such file or directory");
                }
            }
        }
        return CommandResult.SUCCESS;
    }

    private String readFile(InputStream inputStream) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            builder.append(line).append(Config.getLineSeparator());
        }
        inputStream.close();
        return builder.toString();
    }
}

