/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth.sasl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jgroups.auth.sasl.FileObserver;
import org.jgroups.auth.sasl.FileWatchTask;
import org.jgroups.auth.sasl.SecurityActions;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class SimpleAuthorizingCallbackHandler
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(SimpleAuthorizingCallbackHandler.class);
    private final Properties credentials = new Properties();
    private final Properties roles = new Properties();
    private final Timer timer;
    private final String localPrincipal;
    private final String role;
    private final String realm;

    public SimpleAuthorizingCallbackHandler() {
        this(SecurityActions.getSystemProperties());
    }

    public SimpleAuthorizingCallbackHandler(Properties properties) {
        this.localPrincipal = SimpleAuthorizingCallbackHandler.requireProperty(properties, "sasl.local.principal");
        String credentialsFile = SimpleAuthorizingCallbackHandler.requireProperty(properties, "sasl.credentials.properties");
        this.timer = new Timer();
        File fCredentials = new File(credentialsFile);
        this.timer.scheduleAtFixedRate((TimerTask)new FileWatchTask(fCredentials, new PropertiesReloadFileObserver(fCredentials, this.credentials)), 0L, TimeUnit.SECONDS.toMillis(10L));
        this.role = properties.getProperty("sasl.role");
        String rolesFile = properties.getProperty("sasl.roles.properties");
        if (this.role != null) {
            if (rolesFile == null) {
                throw new IllegalStateException("To enable role authorization, both sasl.role and sasl.roles.properties system properties must be set");
            }
            File fRoles = new File(rolesFile);
            this.timer.scheduleAtFixedRate((TimerTask)new FileWatchTask(fRoles, new PropertiesReloadFileObserver(fRoles, this.roles)), 0L, TimeUnit.SECONDS.toMillis(10L));
        }
        this.realm = properties.getProperty("sasl.realm");
    }

    private static String requireProperty(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            throw new IllegalStateException("The required system property " + propertyName + " has not been set");
        }
        return value;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        LinkedList<Callback> responseCallbacks = new LinkedList<Callback>();
        String remotePrincipal = null;
        boolean remotePrincipalFound = false;
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                responseCallbacks.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                remotePrincipal = nameCallback.getDefaultName();
                if (remotePrincipal != null) {
                    remotePrincipalFound = this.credentials.containsKey(remotePrincipal);
                    continue;
                }
                responseCallbacks.add(current);
                continue;
            }
            if (current instanceof PasswordCallback) {
                responseCallbacks.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realmLocal = ((RealmCallback)current).getDefaultText();
                if (realmLocal != null && !this.realm.equals(realmLocal)) {
                    throw new IOException("Invalid realm " + realmLocal);
                }
                responseCallbacks.add(current);
                continue;
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : responseCallbacks) {
            if (current instanceof NameCallback) {
                ((NameCallback)current).setName(this.localPrincipal);
                continue;
            }
            if (current instanceof AuthorizeCallback) {
                String principalRoleNames;
                List principalRoles;
                AuthorizeCallback acb = (AuthorizeCallback)current;
                String authenticationId = acb.getAuthenticationID();
                String authorizationId = acb.getAuthorizationID();
                acb.setAuthorized(authenticationId.equals(authorizationId));
                if (this.role == null || (principalRoles = (principalRoleNames = this.roles.getProperty(acb.getAuthorizationID())) != null ? Arrays.asList(principalRoleNames.split("\\s*,\\s*")) : Collections.emptyList()).contains(this.role)) continue;
                throw new IOException("Unauthorized user " + authorizationId);
            }
            if (current instanceof PasswordCallback) {
                String password;
                if (remotePrincipal == null) {
                    password = this.credentials.getProperty(this.localPrincipal);
                } else if (remotePrincipalFound) {
                    password = this.credentials.getProperty(remotePrincipal);
                } else {
                    throw new IOException("Unauthorized user " + remotePrincipal);
                }
                ((PasswordCallback)current).setPassword(password.toCharArray());
                continue;
            }
            if (!(current instanceof RealmCallback)) continue;
            ((RealmCallback)current).setText(this.realm);
        }
    }

    public static class PropertiesReloadFileObserver
    implements FileObserver {
        private final Properties properties;

        PropertiesReloadFileObserver(File file, Properties properties) {
            this.properties = properties;
            this.loadProperties(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadProperties(File file) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                this.properties.load(fis);
            }
            catch (IOException e) {
                try {
                    log.error(Util.getMessage("AnErrorOccurredWhileLoadingPropertiesFrom") + file, e);
                }
                catch (Throwable throwable) {
                    Util.close(fis);
                    throw throwable;
                }
                Util.close((Closeable)fis);
            }
            Util.close((Closeable)fis);
        }

        @Override
        public void fileChanged(File file) {
            this.loadProperties(file);
        }
    }
}

