/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.Serializable;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.NamingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.realm.ldap.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String emptyParameter$str() {
        return "ELY00002: Parameter %s is empty";
    }

    @Override
    public final IllegalArgumentException emptyParameter(String parameter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyParameter$str(), parameter));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String builderAlreadyBuilt$str() {
        return "ELY00003: This builder has already been built";
    }

    @Override
    public final IllegalStateException builderAlreadyBuilt() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.builderAlreadyBuilt$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unrecognizedAlgorithm$str() {
        return "ELY00004: Unrecognized algorithm \"%s\"";
    }

    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unrecognizedAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void credentialDestroyingFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.credentialDestroyingFailed$str(), new Object[0]);
    }

    protected String credentialDestroyingFailed$str() {
        return "ELY00007: Credential destroying failed";
    }

    protected String couldNotObtainCredential$str() {
        return "ELY01041: Could not obtain credential";
    }

    @Override
    public final RuntimeException couldNotObtainCredential() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainCredential$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotObtainCredentialWithCause$str() {
        return "ELY01042: Could not obtain credential";
    }

    @Override
    public final RuntimeException couldNotObtainCredentialWithCause(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainCredentialWithCause$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String insufficientDataToFormDigestAndSalt$str() {
        return "ELY01053: Insufficient data to form a digest and a salt";
    }

    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.insufficientDataToFormDigestAndSalt$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDirContextSupplierSet$str() {
        return "ELY01057: No DirContext supplier set";
    }

    @Override
    public final IllegalStateException noDirContextSupplierSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noDirContextSupplierSet$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noPrincipalMappingDefinition$str() {
        return "ELY01058: No principal mapping definition";
    }

    @Override
    public final IllegalStateException noPrincipalMappingDefinition() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noPrincipalMappingDefinition$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotObtainPrincipal$str() {
        return "ELY01060: Could not obtain principal";
    }

    @Override
    public final RuntimeException couldNotObtainPrincipal() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotObtainPrincipal$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noProviderUrlSet$str() {
        return "ELY01062: No provider URL has been set";
    }

    @Override
    public final IllegalStateException noProviderUrlSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noProviderUrlSet$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidName$str() {
        return "ELY01064: Invalid identity name";
    }

    @Override
    public final IllegalArgumentException invalidName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidName$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmFailedObtainAttributes$str() {
        return "ELY01079: Ldap-backed realm failed to obtain attributes for entry [%s]";
    }

    @Override
    public final RuntimeException ldapRealmFailedObtainAttributes(String dn, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ldapRealmFailedObtainAttributes$str(), dn), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmInvalidRdnForAttribute$str() {
        return "ELY01080: Attribute [%s] value [%s] must be in X.500 format in order to obtain RDN [%s].";
    }

    @Override
    public final RuntimeException ldapRealmInvalidRdnForAttribute(String attributeName, String value, String rdn, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ldapRealmInvalidRdnForAttribute$str(), attributeName, value, rdn), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmIdentityNotExists$str() {
        return "ELY01083: Ldap-backed realm cannot to obtain not existing identity \"%s\"";
    }

    @Override
    public final RealmUnavailableException ldapRealmIdentityNotExists(String identity) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmIdentityNotExists$str(), identity));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmErrorWhileConsumingResultsFromSearch$str() {
        return "ELY01084: Error while consuming results from search. SearchDn [%s], Filter [%s], Filter Args [%s].";
    }

    @Override
    public final RuntimeException ldapRealmErrorWhileConsumingResultsFromSearch(String searchDn, String filter, String filterArgs, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ldapRealmErrorWhileConsumingResultsFromSearch$str(), searchDn, filter, filterArgs), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmsPersisterNotSupported$str() {
        return "ELY01085: LDAP realm persister does not support given credential type";
    }

    @Override
    public final RealmUnavailableException ldapRealmsPersisterNotSupported() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmsPersisterNotSupported$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmCredentialPersistingFailed$str() {
        return "ELY01086: Persisting credential %s into Ldap-backed realm failed. Identity dn: \"%s\"";
    }

    @Override
    public final RealmUnavailableException ldapRealmCredentialPersistingFailed(String credential, String dn, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmCredentialPersistingFailed$str(), credential, dn), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmCredentialClearingFailed$str() {
        return "ELY01087: Clearing credentials from Ldap-backed realm failed. Identity dn: \"%s\"";
    }

    @Override
    public final RealmUnavailableException ldapRealmCredentialClearingFailed(String dn, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmCredentialClearingFailed$str(), dn), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownLdapPasswordScheme$str() {
        return "ELY01090: Unknown LDAP password scheme";
    }

    @Override
    public final InvalidKeySpecException unknownLdapPasswordScheme() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.unknownLdapPasswordScheme$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchIdentity$str() {
        return "ELY01096: No such identity";
    }

    @Override
    public final RealmUnavailableException noSuchIdentity() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.noSuchIdentity$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmFailedDeleteIdentityFromServer$str() {
        return "ELY01097: Ldap-backed realm failed to delete identity from server";
    }

    @Override
    public final RealmUnavailableException ldapRealmFailedDeleteIdentityFromServer(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmFailedDeleteIdentityFromServer$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmFailedCreateIdentityOnServer$str() {
        return "ELY01098: Ldap-backed realm failed to create identity on server";
    }

    @Override
    public final RealmUnavailableException ldapRealmFailedCreateIdentityOnServer(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmFailedCreateIdentityOnServer$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmNotConfiguredToSupportCreatingIdentities$str() {
        return "ELY01099: Ldap-backed realm is not configured to allow create new identities (new identity parent and attributes has to be set)";
    }

    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportCreatingIdentities() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmNotConfiguredToSupportCreatingIdentities$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmCannotSetAttributeWithoutMapping$str() {
        return "ELY01100: Ldap-backed realm does not contain mapping to set Elytron attribute \"%s\" of identity \"%s\"";
    }

    @Override
    public final RealmUnavailableException ldapRealmCannotSetAttributeWithoutMapping(String attribute, String identity) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmCannotSetAttributeWithoutMapping$str(), attribute, identity));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ldapRealmDoesNotSupportSettingFilteredAttribute(String attribute, String identity) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.ldapRealmDoesNotSupportSettingFilteredAttribute$str(), (Object)attribute, (Object)identity);
    }

    protected String ldapRealmDoesNotSupportSettingFilteredAttribute$str() {
        return "ELY01101: Ldap-backed realm does not support setting of filtered attribute \"%s\" (identity \"%s\")";
    }

    protected String ldapRealmRequiresExactlyOneRdnAttribute$str() {
        return "ELY01102: Ldap-backed realm requires exactly one value of attribute \"%s\" mapped to RDN (identity \"%s\")";
    }

    @Override
    public final RealmUnavailableException ldapRealmRequiresExactlyOneRdnAttribute(String attribute, String identity) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmRequiresExactlyOneRdnAttribute$str(), attribute, identity));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmAttributesSettingFailed$str() {
        return "ELY01103: Ldap-backed realm failed to set attributes of identity \"%s\"";
    }

    @Override
    public final RealmUnavailableException ldapRealmAttributesSettingFailed(String identity, Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmAttributesSettingFailed$str(), identity), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmIdentitySearchFailed$str() {
        return "ELY01108: Ldap-backed realm identity search failed";
    }

    @Override
    public final RealmUnavailableException ldapRealmIdentitySearchFailed(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmIdentitySearchFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmNotConfiguredToSupportIteratingOverIdentities$str() {
        return "ELY01109: Ldap-backed realm is not configured to allow iterate over identities (iterator filter has to be set)";
    }

    @Override
    public final RealmUnavailableException ldapRealmNotConfiguredToSupportIteratingOverIdentities() {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmNotConfiguredToSupportIteratingOverIdentities$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ldapRealmFailedToObtainContext$str() {
        return "ELY01125: Ldap-backed realm failed to obtain context";
    }

    @Override
    public final RealmUnavailableException ldapRealmFailedToObtainContext(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.ldapRealmFailedToObtainContext$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ldapRealmDeferRegistration() {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.ldapRealmDeferRegistration$str(), new Object[0]);
    }

    protected String ldapRealmDeferRegistration$str() {
        return "ELY01146: LDAP Realm unable to register listener, defering action.";
    }

    protected String ldapInvalidLdapName$str() {
        return "ELY01147: Invalid LDAP name [%s]";
    }

    @Override
    public final RuntimeException ldapInvalidLdapName(String name, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.ldapInvalidLdapName$str(), name), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String obtainingDirContextCredentialFromAuthenticationContextFailed$str() {
        return "ELY01150: Obtaining DirContext credentials from AuthenticationContext failed.";
    }

    @Override
    public final NamingException obtainingDirContextCredentialFromAuthenticationContextFailed(Throwable cause) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.obtainingDirContextCredentialFromAuthenticationContextFailed$str(), new Object[0]));
        result.initCause(cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String directLdapVerificationFailed$str() {
        return "ELY01153: Direct LDAP verification failed with DN [%s] and absolute DN [%s]";
    }

    @Override
    public final RealmUnavailableException directLdapVerificationFailed(String distinguishedName, String absoluteName, Exception e) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.directLdapVerificationFailed$str(), distinguishedName, absoluteName), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String threadLocalSslSocketFactoryThreadLocalNotSet$str() {
        return "ELY04025: DirContext tries to connect without ThreadLocalSSLSocketFactory thread local setting";
    }

    @Override
    public final IllegalStateException threadLocalSslSocketFactoryThreadLocalNotSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.threadLocalSslSocketFactoryThreadLocalNotSet$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

