/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import org.aesh.command.Executor;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.readline.Console;
import org.aesh.readline.Process;
import org.aesh.terminal.Connection;

public class ProcessManager {
    private Connection conn;
    private final Console console;
    private Executor<? extends CommandInvocation> executor;

    public ProcessManager(Console console) {
        this.console = console;
    }

    public void execute(Executor<? extends CommandInvocation> executor, Connection conn) {
        this.conn = conn;
        this.executor = executor;
        this.executeNext();
    }

    public boolean hasNext() {
        return this.executor.hasNext();
    }

    public void processFinished(Process process) {
        if (this.hasNext()) {
            this.executeNext();
        } else {
            if (this.executor.hasSkipped()) {
                this.executor.clearSkippedListData();
            }
            if (this.console.running()) {
                this.console.read();
            } else {
                this.conn.close();
            }
        }
    }

    public void executeNext() {
        if (this.hasNext()) {
            new Process(this, this.conn, this.executor.getNextExecution()).start();
        }
    }
}

