/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.atomic;

import java.util.concurrent.CompletionStage;
import org.jgroups.JChannel;
import org.jgroups.blocks.atomic.AsyncCounter;
import org.jgroups.blocks.atomic.BaseCounter;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.blocks.atomic.SyncCounter;
import org.jgroups.protocols.COUNTER;
import org.jgroups.stack.Protocol;
import org.jgroups.util.CompletableFutures;

public class CounterService {
    protected COUNTER counter_prot;

    public CounterService(JChannel ch) {
        this.setChannel(ch);
    }

    public void setChannel(JChannel ch) {
        this.counter_prot = (COUNTER)ch.getProtocolStack().findProtocol((Class<? extends Protocol>)COUNTER.class);
        if (this.counter_prot == null) {
            throw new IllegalStateException("channel configuration must include the COUNTER protocol");
        }
    }

    @Deprecated
    public Counter getOrCreateCounter(String name, long initial_value) {
        return this.counter_prot.getOrCreateCounter(name, initial_value);
    }

    public SyncCounter getOrCreateSyncCounter(String name, long initial_value) {
        return CompletableFutures.join(this.getOrCreateAsyncCounter(name, initial_value).thenApply(BaseCounter::sync));
    }

    public CompletionStage<AsyncCounter> getOrCreateAsyncCounter(String name, long initial_value) {
        return this.counter_prot.getOrCreateAsyncCounter(name, initial_value);
    }

    public void deleteCounter(String name) {
        this.counter_prot.deleteCounter(name);
    }

    public String printCounters() {
        return this.counter_prot.printCounters();
    }

    public String dumpPendingRequests() {
        return this.counter_prot.dumpPendingRequests();
    }
}

