/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remotingjmx.RemotingMBeanServerConnection;
import org.jboss.remotingjmx.VersionedConnection;
import org.jboss.remotingjmx.protocol.v2.ClientCommon;
import org.jboss.remotingjmx.protocol.v2.ClientExecutorManager;
import org.jboss.remotingjmx.protocol.v2.ClientRequestManager;
import org.jboss.remotingjmx.protocol.v2.Common;
import org.jboss.remotingjmx.protocol.v2.VersionedIoFuture;
import org.xnio.IoFuture;

class ClientConnection
extends ClientCommon
implements VersionedConnection {
    private static final Logger log = Logger.getLogger(ClientConnection.class);
    private final Channel channel;
    private final Map<Byte, Common.MessageHandler> handlerRegistry;
    private final String connectionId;
    private TheConnection mbeanServerConnection;
    private final ClientRequestManager clientRequestManager;
    private final ClientExecutorManager clientExecutorManager;
    private LocalNotificationManager localNotificationManager;

    ClientConnection(Channel channel, Map<String, ?> environment, ClientRequestManager clientRequestManager, ClientExecutorManager clientExecutorManager, String connectionId) {
        super(channel, environment);
        this.channel = channel;
        this.clientRequestManager = clientRequestManager;
        this.clientExecutorManager = clientExecutorManager;
        this.connectionId = connectionId;
        this.handlerRegistry = this.createHandlerRegistry();
    }

    private Map<Byte, Common.MessageHandler> createHandlerRegistry() {
        HashMap<Byte, Common.MessageHandler> registry = new HashMap<Byte, Common.MessageHandler>();
        registry.put((byte)-111, new ClientCommon.MarshalledResponseHandler(0));
        registry.put((byte)-127, new ClientCommon.MarshalledResponseHandler(12));
        registry.put((byte)-120, new ClientCommon.MarshalledResponseHandler(4));
        registry.put((byte)-119, new ClientCommon.MarshalledResponseHandler(2));
        registry.put((byte)-115, new ClientCommon.StringResponseHandler());
        registry.put((byte)-114, new StringArrayResponseHandler());
        registry.put((byte)-121, new IntegerResponseHandler());
        registry.put((byte)-113, new ClientCommon.MarshalledResponseHandler(14));
        registry.put((byte)-125, new ClientCommon.MarshalledResponseHandler(12));
        registry.put((byte)-112, new BooleanResponseHandler());
        registry.put((byte)-122, new BooleanResponseHandler());
        registry.put((byte)-116, new ClientCommon.MarshalledResponseHandler(4));
        registry.put((byte)-124, new ClientCommon.MarshalledResponseHandler(13));
        registry.put((byte)-123, new ClientCommon.MarshalledResponseHandler(15));
        registry.put((byte)-110, new ClientCommon.MarshalledResponseHandler(0));
        registry.put((byte)-118, new ClientCommon.MarshalledResponseHandler(0));
        registry.put((byte)-117, new ClientCommon.MarshalledResponseHandler(2));
        registry.put((byte)-126, new ClientCommon.MarshalledResponseHandler(0));
        registry.put((byte)19, new NotificationHandler());
        return Collections.unmodifiableMap(registry);
    }

    void start() {
        this.mbeanServerConnection = new TheConnection();
        this.localNotificationManager = new LocalNotificationManager();
        this.channel.receiveMessage(new ClientCommon.MessageReceiver());
    }

    @Override
    Map<Byte, Common.MessageHandler> getHandlerRegistry() {
        return this.handlerRegistry;
    }

    @Override
    protected ClientRequestManager getClientRequestManager() {
        return this.clientRequestManager;
    }

    @Override
    protected ClientExecutorManager getClientExecutorManager() {
        return this.clientExecutorManager;
    }

    @Override
    public String getConnectionId() {
        if (this.connectionId == null) {
            throw new IllegalStateException("Connection ID not set");
        }
        return this.connectionId;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject subject) {
        if (subject != null) {
            throw new UnsupportedOperationException("Subject delegation not supported for getMBeanServerConnection");
        }
        return this.mbeanServerConnection;
    }

    @Override
    public void close() {
        this.clientExecutorManager.close();
    }

    private class NotificationHandler
    implements Common.MessageHandler {
        private NotificationHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            log.trace("Notification");
            byte paramType = input.readByte();
            if (paramType != 11) {
                throw new IOException("Unexpected paramType");
            }
            int listenerId = input.readInt();
            paramType = input.readByte();
            if (paramType != 17) {
                throw new IOException("Unexpected paramType");
            }
            try {
                Unmarshaller unmarshaller = ClientConnection.this.prepareForUnMarshalling(input);
                Notification notification = unmarshaller.readObject(Notification.class);
                paramType = unmarshaller.readByte();
                if (paramType != 4) {
                    throw new IOException("Unexpected paramType");
                }
                Object handBack = unmarshaller.readObject();
                ClientConnection.this.localNotificationManager.notify(listenerId, notification, handBack);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
        }
    }

    private class StringArrayResponseHandler
    extends ClientCommon.BaseResponseHandler<String[]> {
        private StringArrayResponseHandler() {
        }

        @Override
        protected byte getExpectedType() {
            return 9;
        }

        @Override
        protected String[] readValue(DataInput input) throws IOException {
            int count = input.readInt();
            String[] response = new String[count];
            for (int i = 0; i < count; ++i) {
                response[i] = input.readUTF();
            }
            return response;
        }
    }

    private class IntegerResponseHandler
    extends ClientCommon.BaseResponseHandler<Integer> {
        private IntegerResponseHandler() {
        }

        @Override
        protected byte getExpectedType() {
            return 11;
        }

        @Override
        protected Integer readValue(DataInput input) throws IOException {
            return input.readInt();
        }
    }

    private class BooleanResponseHandler
    extends ClientCommon.BaseResponseHandler<Boolean> {
        private BooleanResponseHandler() {
        }

        @Override
        protected byte getExpectedType() {
            return 10;
        }

        @Override
        protected Boolean readValue(DataInput input) throws IOException {
            return input.readBoolean();
        }
    }

    private class TheConnection
    implements RemotingMBeanServerConnection {
        private TheConnection() {
        }

        @Override
        public Connection getConnection() {
            return ClientConnection.this.channel.getConnection();
        }

        @Override
        public ObjectInstance createMBean(final String className, final ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(1);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(2);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                        marshaller.writeByte(6);
                        marshaller.writeObject(name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] createMBean - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.reflectionException(response.e);
                        this.instanceAlreadyExistsException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.mbeanException(response.e);
                        this.notCompliantMBeanException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain createMBean, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public ObjectInstance createMBean(final String className, final ObjectName name, final ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(1);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(3);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                        marshaller.writeByte(6);
                        marshaller.writeObject(name);
                        marshaller.writeByte(6);
                        marshaller.writeObject(loaderName);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] createMBean - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.reflectionException(response.e);
                        this.instanceAlreadyExistsException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.mbeanException(response.e);
                        this.notCompliantMBeanException(response.e);
                        this.instanceNotFoundException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public ObjectInstance createMBean(final String className, final ObjectName name, final Object[] params, final String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(1);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(4);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                        marshaller.writeByte(6);
                        marshaller.writeObject(name);
                        marshaller.writeByte(5);
                        marshaller.writeInt(params.length);
                        for (Object object : params) {
                            marshaller.writeObject(object);
                        }
                        marshaller.writeByte(9);
                        marshaller.writeInt(signature.length);
                        for (String string : signature) {
                            marshaller.writeUTF(string);
                        }
                        marshaller.close();
                    }
                });
                log.tracef("[%d] createMBean - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.reflectionException(response.e);
                        this.instanceAlreadyExistsException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.mbeanException(response.e);
                        this.notCompliantMBeanException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke createMBean, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public ObjectInstance createMBean(final String className, final ObjectName name, final ObjectName loaderName, final Object[] params, final String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(1);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(5);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                        marshaller.writeByte(6);
                        marshaller.writeObject(name);
                        marshaller.writeByte(6);
                        marshaller.writeObject(loaderName);
                        marshaller.writeByte(5);
                        marshaller.writeInt(params.length);
                        for (Object object : params) {
                            marshaller.writeObject(object);
                        }
                        marshaller.writeByte(9);
                        marshaller.writeInt(signature.length);
                        for (String string : signature) {
                            marshaller.writeUTF(string);
                        }
                        marshaller.close();
                    }
                });
                log.tracef("[%d] createMBean - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.reflectionException(response.e);
                        this.instanceAlreadyExistsException(response.e);
                        this.mbeanRegistrationException(response.e);
                        this.mbeanException(response.e);
                        this.notCompliantMBeanException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke createMBean, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void unregisterMBean(final ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(2);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] unregisterMBean - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        this.mbeanRegistrationException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke unregisterMBean, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public ObjectInstance getObjectInstance(final ObjectName name) throws InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(3);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] getObjectInstance - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            ObjectInstance objectInstance = (ObjectInstance)response.value;
                            return objectInstance;
                        }
                        this.instanceNotFoundException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke getObjectInstance, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Set<ObjectInstance> queryMBeans(final ObjectName name, final QueryExp query) throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(4);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(7);
                        marshaller.writeObject(query);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] queryMBeans - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Set set = (Set)response.value;
                            return set;
                        }
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke queryMBeans, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Set<ObjectName> queryNames(final ObjectName name, final QueryExp query) throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(5);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(7);
                        marshaller.writeObject(query);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] queryNames - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Set set = (Set)response.value;
                            return set;
                        }
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public boolean isRegistered(final ObjectName name) throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(6);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] isRegistered - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            boolean bl = (Boolean)response.value;
                            return bl;
                        }
                        throw ClientConnection.this.toIoException(response.e);
                    }
                    case FAILED: {
                        throw future.getException();
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Integer getMBeanCount() throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(7);
                        output.writeInt(correlationId);
                    }
                });
                log.tracef("[%d] getMBeanCount - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Integer n = (Integer)response.value;
                            return n;
                        }
                        throw ClientConnection.this.toIoException(response.e);
                    }
                    case FAILED: {
                        throw future.getException();
                    }
                }
                throw new IOException("Unable to obtain MBeanCount, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Object getAttribute(final ObjectName name, final String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(8);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(attribute);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] getAttribute - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Object t = response.value;
                            return t;
                        }
                        this.mbeanException(response.e);
                        this.attributeNotFoundException(response.e);
                        this.instanceNotFoundException(response.e);
                        this.reflectionException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public AttributeList getAttributes(final ObjectName name, final String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(9);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(9);
                        marshaller.writeInt(attributes.length);
                        for (String current : attributes) {
                            marshaller.writeUTF(current);
                        }
                        marshaller.close();
                    }
                });
                log.tracef("[%d] getAttributes - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            AttributeList attributeList = (AttributeList)response.value;
                            return attributeList;
                        }
                        this.instanceNotFoundException(response.e);
                        this.reflectionException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke getAttributes, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void setAttribute(final ObjectName name, final Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(10);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(1);
                        marshaller.writeObject(attribute);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] setAttribute - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        this.attributeNotFoundException(response.e);
                        this.invalidAttributeValueException(response.e);
                        this.mbeanException(response.e);
                        this.reflectionException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke setAttribute, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public AttributeList setAttributes(final ObjectName name, final AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(11);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(2);
                        marshaller.writeObject(attributes);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] setAttributes - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            AttributeList attributeList = (AttributeList)response.value;
                            return attributeList;
                        }
                        this.instanceNotFoundException(response.e);
                        this.reflectionException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke setAttributes, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public Object invoke(final ObjectName name, final String operationName, final Object[] params, final String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(12);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(operationName);
                        marshaller.writeByte(5);
                        if (params != null) {
                            marshaller.writeInt(params.length);
                            for (Object object : params) {
                                marshaller.writeObject(object);
                            }
                        } else {
                            marshaller.writeInt(0);
                        }
                        marshaller.writeByte(9);
                        if (signature != null) {
                            marshaller.writeInt(signature.length);
                            for (String string : signature) {
                                marshaller.writeUTF(string);
                            }
                        } else {
                            marshaller.writeInt(0);
                        }
                        marshaller.close();
                    }
                });
                log.tracef("[%d] invoke - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            Object t = response.value;
                            return t;
                        }
                        this.instanceNotFoundException(response.e);
                        this.mbeanException(response.e);
                        this.reflectionException(response.e);
                        this.runtimeMBeanException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke invoke(), status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public String getDefaultDomain() throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(13);
                        output.writeInt(correlationId);
                    }
                });
                log.tracef("[%d] getDefaultDomain - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            String string = (String)response.value;
                            return string;
                        }
                        throw ClientConnection.this.toIoException(response.e);
                    }
                    case FAILED: {
                        throw future.getException();
                    }
                }
                throw new IOException("Unable to obtain DefaultDomain, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public String[] getDomains() throws IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(14);
                        output.writeInt(correlationId);
                    }
                });
                log.tracef("[%d] getDomains - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            String[] stringArray = (String[])response.value;
                            return stringArray;
                        }
                        throw ClientConnection.this.toIoException(response.e);
                    }
                    case FAILED: {
                        throw future.getException();
                    }
                }
                throw new IOException("Unable to obtain Domains, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void addNotificationListener(final ObjectName name, NotificationListener listener, final NotificationFilter filter, final Object handback) throws InstanceNotFoundException, IOException {
            final int notificationId = ClientConnection.this.localNotificationManager.associate(name, listener, filter, handback);
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(17);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(11);
                        marshaller.writeInt(notificationId);
                        marshaller.writeByte(16);
                        marshaller.writeObject(filter);
                        marshaller.writeByte(4);
                        marshaller.writeObject(handback);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] addNotificationListener - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        ClientConnection.this.localNotificationManager.cancel(notificationId);
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        ClientConnection.this.localNotificationManager.cancel(notificationId);
                        this.instanceNotFoundException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                ClientConnection.this.localNotificationManager.cancel(notificationId);
                throw new IOException("Unable to invoke addNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void addNotificationListener(final ObjectName name, final ObjectName listener, final NotificationFilter filter, final Object handback) throws InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(17);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(6);
                        marshaller.writeObject(listener);
                        marshaller.writeByte(16);
                        marshaller.writeObject(filter);
                        marshaller.writeByte(4);
                        marshaller.writeObject(handback);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] addNotificationListener - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke addNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void removeNotificationListener(final ObjectName name, final ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(18);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(2);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(6);
                        marshaller.writeObject(listener);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] removeNotificationListener - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke removeNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void removeNotificationListener(final ObjectName name, final ObjectName listener, final NotificationFilter filter, final Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(18);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(4);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(6);
                        marshaller.writeObject(listener);
                        marshaller.writeByte(16);
                        marshaller.writeObject(filter);
                        marshaller.writeByte(4);
                        marshaller.writeObject(handback);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] removeNotificationListener - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke removeNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        private void removeNotificationListener(final int[] listenerIds) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(18);
                        output.writeInt(correlationId);
                        output.writeByte(11);
                        output.writeInt(1);
                        output.writeByte(18);
                        output.writeInt(listenerIds.length);
                        for (int current : listenerIds) {
                            output.writeInt(current);
                        }
                    }
                });
                log.tracef("[%d] removeNotificationListener - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            return;
                        }
                        this.instanceNotFoundException(response.e);
                        this.listenerNotFoundException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to invoke removeNotificationListener, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.removeNotificationListener(ClientConnection.this.localNotificationManager.matchToRemove(name, listener));
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.removeNotificationListener(ClientConnection.this.localNotificationManager.matchToRemove(name, listener, filter, handback));
        }

        @Override
        public MBeanInfo getMBeanInfo(final ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(15);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.close();
                    }
                });
                log.tracef("[%d] getMBeanInfo - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            MBeanInfo mBeanInfo = (MBeanInfo)response.value;
                            return mBeanInfo;
                        }
                        this.instanceNotFoundException(response.e);
                        this.introspectionException(response.e);
                        this.reflectionException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        @Override
        public boolean isInstanceOf(final ObjectName name, final String className) throws InstanceNotFoundException, IOException {
            VersionedIoFuture future = new VersionedIoFuture();
            final int correlationId = ClientConnection.this.clientRequestManager.reserveNextCorrelationId(future);
            try {
                ClientConnection.this.write(new Common.MessageWriter(){

                    @Override
                    public void write(DataOutput output) throws IOException {
                        output.writeByte(16);
                        output.writeInt(correlationId);
                        output.writeByte(6);
                        Marshaller marshaller = ClientConnection.this.prepareForMarshalling(output);
                        marshaller.writeObject(name);
                        marshaller.writeByte(8);
                        marshaller.writeUTF(className);
                    }
                });
                log.tracef("[%d] isInstanceOf - Request Sent", (Object)correlationId);
                IoFuture.Status result = future.await(ClientConnection.this.timeoutSeconds, TimeUnit.SECONDS);
                switch (result) {
                    case FAILED: {
                        throw future.getException();
                    }
                    case DONE: {
                        ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                        if (response.e == null) {
                            boolean bl = (Boolean)response.value;
                            return bl;
                        }
                        this.instanceNotFoundException(response.e);
                        throw ClientConnection.this.toIoException(response.e);
                    }
                }
                throw new IOException("Unable to obtain isRegistered, status=" + result.toString());
            }
            finally {
                ClientConnection.this.clientRequestManager.releaseCorrelationId(correlationId);
            }
        }

        private void attributeNotFoundException(Exception e) throws AttributeNotFoundException {
            if (e != null && e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
        }

        private void instanceAlreadyExistsException(Exception e) throws InstanceAlreadyExistsException {
            if (e != null && e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
        }

        private void instanceNotFoundException(Exception e) throws InstanceNotFoundException {
            if (e != null && e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
        }

        private void introspectionException(Exception e) throws IntrospectionException {
            if (e != null && e instanceof IntrospectionException) {
                throw (IntrospectionException)e;
            }
        }

        private void invalidAttributeValueException(Exception e) throws InvalidAttributeValueException {
            if (e != null && e instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)e;
            }
        }

        private void listenerNotFoundException(Exception e) throws ListenerNotFoundException {
            if (e != null && e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
        }

        private void mbeanRegistrationException(Exception e) throws MBeanRegistrationException {
            if (e != null && e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
        }

        private void mbeanException(Exception e) throws MBeanException {
            if (e != null && e instanceof MBeanException) {
                throw (MBeanException)e;
            }
        }

        private void notCompliantMBeanException(Exception e) throws NotCompliantMBeanException {
            if (e != null && e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
        }

        private void reflectionException(Exception e) throws ReflectionException {
            if (e != null && e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
        }

        private void runtimeMBeanException(Exception e) {
            if (e instanceof RuntimeMBeanException) {
                throw (RuntimeMBeanException)e;
            }
        }
    }

    private class LocalNotificationManager {
        private int nextNotificationId = 1;
        private Map<Integer, Association> listeners = new HashMap<Integer, Association>();

        private LocalNotificationManager() {
        }

        private synchronized int getNextNotificationId() {
            int next;
            if ((next = this.nextNotificationId++) < 0) {
                this.nextNotificationId = 2;
                next = 1;
            }
            return next;
        }

        private synchronized int associate(ObjectName target, NotificationListener listener, NotificationFilter filter, Object handBack) {
            Integer next = this.getNextNotificationId();
            while (this.listeners.containsKey(next)) {
                next = this.getNextNotificationId();
            }
            Association association = new Association();
            association.target = target;
            association.listener = listener;
            association.filter = filter;
            association.handBack = handBack;
            this.listeners.put(next, association);
            return next;
        }

        private synchronized void cancel(int id) {
            this.listeners.remove(id);
        }

        private synchronized Association get(int id) {
            return this.listeners.get(id);
        }

        private void notify(int id, Notification n, Object handback) {
            Association association = this.get(id);
            if (association != null) {
                association.listener.handleNotification(n, handback);
            } else {
                try {
                    log.warnf("Notification recieved for non existant NotificationListener %d", (Object)id);
                    ClientConnection.this.mbeanServerConnection.removeNotificationListener(new int[]{id});
                }
                catch (InstanceNotFoundException e) {
                }
                catch (ListenerNotFoundException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }

        private synchronized int[] matchToRemove(ObjectName name, NotificationListener listener) {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer current : this.listeners.keySet()) {
                Association association = this.listeners.get(current);
                if (name != association.target && (!name.equals(association.target) || listener != association.listener)) continue;
                toRemove.add(current);
            }
            int[] response = new int[toRemove.size()];
            for (int i = 0; i < response.length; ++i) {
                response[i] = (Integer)toRemove.get(i);
                this.listeners.remove(response[i]);
            }
            return response;
        }

        private synchronized int[] matchToRemove(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer current : this.listeners.keySet()) {
                Association association = this.listeners.get(current);
                if (name != association.target && !name.equals(association.target) || listener != association.listener || filter != association.filter || handback != association.handBack) continue;
                toRemove.add(current);
            }
            int[] response = new int[toRemove.size()];
            for (int i = 0; i < response.length; ++i) {
                response[i] = (Integer)toRemove.get(i);
                this.listeners.remove(response[i]);
            }
            return response;
        }

        private class Association {
            private ObjectName target;
            private NotificationListener listener;
            private NotificationFilter filter;
            private Object handBack;

            private Association() {
            }
        }
    }
}

