/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.CommandLine;
import org.jboss.as.cli.gui.DoOperationActionListener;
import org.jboss.as.cli.gui.ManagementModel;
import org.jboss.as.cli.gui.SelectPreviousOpMouseAdapter;
import org.jboss.as.cli.gui.component.CLIOutput;
import org.jboss.as.cli.gui.component.ScriptMenu;
import org.jboss.as.cli.gui.component.TabsMenu;
import org.jboss.as.cli.gui.metacommand.DeployAction;
import org.jboss.as.cli.gui.metacommand.UndeployAction;

public class GuiMain {
    private static Image jbossIcon;
    private static final Preferences PREFERENCES;
    private static String LOOK_AND_FEEL_KEY;

    private GuiMain() {
    }

    public static void start(CommandContext cmdCtx) {
        GuiMain.initJFrame(GuiMain.makeGuiContext(cmdCtx));
    }

    public static CliGuiContext startEmbedded(CommandContext cmdCtx) {
        return GuiMain.makeGuiContext(cmdCtx);
    }

    private static CliGuiContext makeGuiContext(CommandContext cmdCtx) {
        CliGuiContext cliGuiCtx = new CliGuiContext();
        cliGuiCtx.setCommandContext(cmdCtx);
        CommandExecutor executor = new CommandExecutor(cliGuiCtx);
        cliGuiCtx.setExecutor(executor);
        CLIOutput output = new CLIOutput();
        cliGuiCtx.setOutput(output);
        JPanel outputDisplay = GuiMain.makeOutputDisplay(output);
        JTabbedPane tabs = GuiMain.makeTabbedPane(cliGuiCtx, outputDisplay);
        cliGuiCtx.setTabs(tabs);
        DoOperationActionListener opListener = new DoOperationActionListener(cliGuiCtx);
        CommandLine cmdLine = new CommandLine(opListener);
        cliGuiCtx.setCommandLine(cmdLine);
        output.addMouseListener(new SelectPreviousOpMouseAdapter(cliGuiCtx, opListener));
        JPanel mainPanel = GuiMain.makeMainPanel(tabs, cmdLine);
        cliGuiCtx.setMainPanel(mainPanel);
        return cliGuiCtx;
    }

    private static JPanel makeMainPanel(JTabbedPane tabs, CommandLine cmdLine) {
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEtchedBorder());
        mainPanel.setLayout(new BorderLayout(5, 5));
        mainPanel.add((Component)cmdLine, "North");
        mainPanel.add((Component)tabs, "Center");
        return mainPanel;
    }

    public static Image getJBossIcon() {
        return jbossIcon;
    }

    private static synchronized void initJFrame(CliGuiContext cliGuiCtx) {
        JFrame frame = new JFrame("CLI GUI");
        frame.setIconImage(GuiMain.getJBossIcon());
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setJMenuBar(GuiMain.makeMenuBar(cliGuiCtx));
        frame.setSize(800, 600);
        Container contentPane = frame.getContentPane();
        contentPane.add((Component)cliGuiCtx.getMainPanel(), "Center");
        GuiMain.setUpLookAndFeel(cliGuiCtx.getMainWindow());
        frame.setVisible(true);
    }

    public static JMenuBar makeMenuBar(CliGuiContext cliGuiCtx) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(GuiMain.makeDeploymentsMenu(cliGuiCtx));
        menuBar.add(new TabsMenu(cliGuiCtx));
        menuBar.add(new ScriptMenu(cliGuiCtx));
        JMenu lfMenu = GuiMain.makeLookAndFeelMenu(cliGuiCtx);
        if (lfMenu != null) {
            menuBar.add(lfMenu);
        }
        return menuBar;
    }

    private static JMenu makeLookAndFeelMenu(CliGuiContext cliGuiCtx) {
        UIManager.LookAndFeelInfo[] all = UIManager.getInstalledLookAndFeels();
        if (all == null) {
            return null;
        }
        JMenu lfMenu = new JMenu("Look & Feel");
        lfMenu.setMnemonic(76);
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : all) {
            JMenuItem item = new JMenuItem(new ChangeLookAndFeelAction(cliGuiCtx, lookAndFeelInfo));
            lfMenu.add(item);
        }
        return lfMenu;
    }

    private static JMenu makeDeploymentsMenu(CliGuiContext cliGuiCtx) {
        JMenu metaCmdMenu = new JMenu("Deployments");
        metaCmdMenu.setMnemonic(68);
        JMenuItem deploy = new JMenuItem(new DeployAction(cliGuiCtx));
        deploy.setMnemonic(68);
        metaCmdMenu.add(deploy);
        JMenuItem unDeploy = new JMenuItem(new UndeployAction(cliGuiCtx));
        unDeploy.setMnemonic(85);
        metaCmdMenu.add(unDeploy);
        return metaCmdMenu;
    }

    private static JTabbedPane makeTabbedPane(CliGuiContext cliGuiCtx, JPanel output) {
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Command Builder", new ManagementModel(cliGuiCtx));
        tabs.addTab("Output", output);
        return tabs;
    }

    private static JPanel makeOutputDisplay(CLIOutput output) {
        JPanel outputDisplay = new JPanel();
        outputDisplay.setSize(400, 5000);
        outputDisplay.setLayout(new BorderLayout(5, 5));
        outputDisplay.add((Component)new JScrollPane(output), "Center");
        return outputDisplay;
    }

    public static void setUpLookAndFeel(Window mainWindow) {
        try {
            String laf = PREFERENCES.get(LOOK_AND_FEEL_KEY, UIManager.getSystemLookAndFeelClassName());
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(mainWindow);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void showErrorDialog(Window window, String title, Throwable t) {
        JOptionPane.showMessageDialog(window, t.getLocalizedMessage(), title, 0);
    }

    static {
        URL iconURL = GuiMain.class.getResource("/icon/wildfly.png");
        jbossIcon = Toolkit.getDefaultToolkit().getImage(iconURL);
        ToolTipManager.sharedInstance().setDismissDelay(15000);
        PREFERENCES = Preferences.userNodeForPackage(GuiMain.class);
        LOOK_AND_FEEL_KEY = "cli-gui-laf";
    }

    private static class ChangeLookAndFeelAction
    extends AbstractAction {
        private static final String errorTitle = "Look & Feel Not Set";
        private CliGuiContext cliGuiCtx;
        private UIManager.LookAndFeelInfo lookAndFeelInfo;

        ChangeLookAndFeelAction(CliGuiContext cliGuiCtx, UIManager.LookAndFeelInfo lookAndFeelInfo) {
            super(lookAndFeelInfo.getName());
            this.cliGuiCtx = cliGuiCtx;
            this.lookAndFeelInfo = lookAndFeelInfo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window mainWindow = this.cliGuiCtx.getMainWindow();
            try {
                UIManager.setLookAndFeel(this.lookAndFeelInfo.getClassName());
                SwingUtilities.updateComponentTreeUI(mainWindow);
                PREFERENCES.put(LOOK_AND_FEEL_KEY, this.lookAndFeelInfo.getClassName());
            }
            catch (Exception ex) {
                GuiMain.showErrorDialog(mainWindow, errorTitle, ex);
            }
        }
    }
}

