/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class RestartParentAddHandler<T>
extends RestartParentResourceAddHandler
implements Registration {
    private final ResourceDescriptionResolver resolver;
    private final ResourceServiceBuilderFactory<T> builderFactory;
    private final List<Attribute> attributes = new LinkedList<Attribute>();

    public RestartParentAddHandler(ResourceDescriptionResolver resolver, ResourceServiceBuilderFactory<T> builderFactory) {
        super(null);
        this.resolver = resolver;
        this.builderFactory = builderFactory;
    }

    public <E extends Enum<E>> RestartParentAddHandler<T> addAttributes(Class<E> enumClass) {
        return this.addAttributes(EnumSet.allOf(enumClass));
    }

    public RestartParentAddHandler<T> addAttributes(Attribute ... attributes) {
        return this.addAttributes(Arrays.asList(attributes));
    }

    public RestartParentAddHandler<T> addAttributes(Collection<? extends Attribute> attributes) {
        this.attributes.addAll(attributes);
        return this;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (Attribute attribute : this.attributes) {
            ((AttributeDefinition)attribute.getDefinition()).validateAndSet(operation, model);
        }
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        this.builderFactory.createBuilder(parentAddress).configure((ExpressionResolver)context, parentModel).build(context.getServiceTarget()).install();
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return this.builderFactory.createBuilder(parentAddress).getServiceName();
    }

    protected PathAddress getParentAddress(PathAddress address) {
        return address.getParent();
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder("add", this.resolver).withFlag(OperationEntry.Flag.RESTART_NONE);
        for (Attribute attribute : this.attributes) {
            builder.addParameter((AttributeDefinition)attribute.getDefinition());
        }
        registration.registerOperationHandler((OperationDefinition)builder.build(), (OperationStepHandler)this);
    }
}

