/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class RestartParentResourceWriteAttributeHandler<T>
extends RestartParentWriteAttributeHandler
implements Registration {
    private final ResourceServiceBuilderFactory<T> builderFactory;
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();

    public <E extends Enum<E>> RestartParentResourceWriteAttributeHandler(ResourceServiceBuilderFactory<T> builderFactory, Class<E> enumClass) {
        this(builderFactory, EnumSet.allOf(enumClass));
    }

    public RestartParentResourceWriteAttributeHandler(ResourceServiceBuilderFactory<T> builderFactory, Attribute ... attributes) {
        this(builderFactory, Arrays.asList(attributes));
    }

    public RestartParentResourceWriteAttributeHandler(ResourceServiceBuilderFactory<T> builderFactory, Iterable<? extends Attribute> attributes) {
        super(null, new AttributeDefinition[0]);
        this.builderFactory = builderFactory;
        for (Attribute attribute : attributes) {
            AttributeDefinition definition = (AttributeDefinition)attribute.getDefinition();
            this.attributes.put(definition.getName(), definition);
        }
    }

    protected AttributeDefinition getAttributeDefinition(String name) {
        return this.attributes.get(name);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        this.builderFactory.createBuilder(parentAddress).configure(context, parentModel).build(context.getServiceTarget()).install();
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return this.builderFactory.createBuilder(parentAddress).getServiceName();
    }

    protected PathAddress getParentAddress(PathAddress address) {
        return address.getParent();
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        for (AttributeDefinition attribute : this.attributes.values()) {
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)this);
        }
    }
}

