/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectorDependency;
import org.wildfly.clustering.service.SimpleDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.source.CredentialSource;

public class CredentialSourceDependency
implements ValueDependency<CredentialSource> {
    private final ExceptionSupplier<CredentialSource, Exception> supplier;
    private final Iterable<Dependency> dependencies;

    public CredentialSourceDependency(OperationContext context, Attribute attribute, ModelNode model) throws OperationFailedException {
        DependencyCollectingServiceBuilder builder = new DependencyCollectingServiceBuilder();
        this.supplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)((ObjectTypeAttributeDefinition)attribute.getDefinition()), (ModelNode)model, (ServiceBuilder)builder);
        this.dependencies = builder;
    }

    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        for (Dependency dependency : this.dependencies) {
            dependency.register(builder);
        }
        return builder;
    }

    public CredentialSource getValue() {
        try {
            return (CredentialSource)this.supplier.get();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static class DependencyCollectingServiceBuilder
    extends DelegatingServiceBuilder<Object>
    implements Iterable<Dependency> {
        private final List<Dependency> dependencies = new LinkedList<Dependency>();

        DependencyCollectingServiceBuilder() {
            super(null);
        }

        protected ServiceBuilder getDelegate() {
            throw new IllegalStateException();
        }

        @Override
        public Iterator<Dependency> iterator() {
            return this.dependencies.iterator();
        }

        @Deprecated
        public ServiceBuilder<Object> addDependencies(ServiceName ... serviceNames) {
            this.addDependencies(Arrays.asList(serviceNames));
            return this;
        }

        @Deprecated
        public ServiceBuilder<Object> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... serviceNames) {
            if (dependencyType != ServiceBuilder.DependencyType.REQUIRED) {
                throw new UnsupportedOperationException();
            }
            return this.addDependencies(serviceNames);
        }

        @Deprecated
        public ServiceBuilder<Object> addDependencies(Iterable<ServiceName> serviceNames) {
            for (ServiceName serviceName : serviceNames) {
                this.dependencies.add((Dependency)new SimpleDependency(serviceName));
            }
            return this;
        }

        @Deprecated
        public ServiceBuilder<Object> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> serviceNames) {
            if (dependencyType != ServiceBuilder.DependencyType.REQUIRED) {
                throw new UnsupportedOperationException();
            }
            return this.addDependencies(serviceNames);
        }

        @Deprecated
        public ServiceBuilder<Object> addDependency(ServiceName serviceName) {
            this.dependencies.add((Dependency)new SimpleDependency(serviceName));
            return this;
        }

        @Deprecated
        public ServiceBuilder<Object> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName serviceName) {
            if (dependencyType != ServiceBuilder.DependencyType.REQUIRED) {
                throw new UnsupportedOperationException();
            }
            return this.addDependency(serviceName);
        }

        @Deprecated
        public ServiceBuilder<Object> addDependency(ServiceName serviceName, Injector<Object> target) {
            return this.addDependency(serviceName, Object.class, target);
        }

        @Deprecated
        public ServiceBuilder<Object> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName serviceName, Injector<Object> target) {
            return this.addDependency(dependencyType, serviceName, Object.class, target);
        }

        @Deprecated
        public <I> ServiceBuilder<Object> addDependency(ServiceName serviceName, Class<I> type, Injector<I> target) {
            this.dependencies.add((Dependency)new InjectorDependency(serviceName, type, target));
            return this;
        }

        @Deprecated
        public <I> ServiceBuilder<Object> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName serviceName, Class<I> type, Injector<I> target) {
            if (dependencyType != ServiceBuilder.DependencyType.REQUIRED) {
                throw new UnsupportedOperationException();
            }
            return this.addDependency(serviceName, type, target);
        }
    }
}

