/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.AttributeValueTranslator;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class ReadAttributeTranslationHandler
implements OperationStepHandler {
    private final AttributeTranslation translation;

    public ReadAttributeTranslationHandler(AttributeTranslation translation) {
        this.translation = translation;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress currentAddress = context.getCurrentAddress();
        PathAddress targetAddress = (PathAddress)this.translation.getPathAddressTransformation().apply(currentAddress);
        Attribute targetAttribute = this.translation.getTargetAttribute();
        ModelNode targetOperation = Operations.createReadAttributeOperation(targetAddress, targetAttribute);
        ImmutableManagementResourceRegistration targetRegistration = (ImmutableManagementResourceRegistration)this.translation.getResourceRegistrationTransformation().apply(context.getResourceRegistration());
        OperationStepHandler readAttributeHandler = targetRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, targetAttribute.getName()).getReadHandler();
        ReadTranslatedAttributeStepHandler readTranslatedAttributeHandler = new ReadTranslatedAttributeStepHandler(readAttributeHandler, targetAttribute, this.translation.getReadTranslator());
        if (targetAddress == currentAddress) {
            readTranslatedAttributeHandler.execute(context, targetOperation);
        } else {
            context.addStep(targetOperation, (OperationStepHandler)readTranslatedAttributeHandler, context.getCurrentStage(), true);
        }
    }

    private static class ReadTranslatedAttributeStepHandler
    implements OperationStepHandler {
        private final OperationStepHandler readHandler;
        private final Attribute targetAttribute;
        private final AttributeValueTranslator translator;

        ReadTranslatedAttributeStepHandler(OperationStepHandler readHandler, Attribute targetAttribute, AttributeValueTranslator translator) {
            this.readHandler = readHandler;
            this.targetAttribute = targetAttribute;
            this.translator = translator;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (this.readHandler != null) {
                this.readHandler.execute(context, operation);
            } else {
                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
                ModelNode result = context.getResult();
                if (model.hasDefined(this.targetAttribute.getName())) {
                    result.set(model.get(this.targetAttribute.getName()));
                } else if (Operations.isIncludeDefaults(operation)) {
                    result.set(((AttributeDefinition)this.targetAttribute.getDefinition()).getDefaultValue());
                }
            }
            ModelNode result = context.getResult();
            result.set(this.translator.translate(context, result));
        }
    }
}

