/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.context;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jboss.as.clustering.context.ContextReference;
import org.jboss.as.clustering.context.ContextReferenceExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class ContextReferenceExecutorTestCase {
    @Test
    public void test() throws Exception {
        Object original = new Object();
        final Object target = new Object();
        final Object result = new Object();
        final AtomicReference resultRef = new AtomicReference();
        final AtomicContextReference<Object> contextRef = new AtomicContextReference<Object>(original);
        ContextReferenceExecutor contextualizer = new ContextReferenceExecutor(target, contextRef);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Assert.assertSame((Object)target, (Object)contextRef.get());
                resultRef.set(result);
            }
        };
        Assert.assertSame((Object)original, (Object)contextRef.get());
        contextualizer.contextualize(runner).run();
        Assert.assertSame((Object)original, (Object)contextRef.get());
        Assert.assertSame((Object)result, resultRef.get());
        resultRef.set(null);
        ExceptionRunnable<Exception> exceptionRunner = new ExceptionRunnable<Exception>(){

            public void run() throws Exception {
                Assert.assertSame((Object)target, (Object)contextRef.get());
                resultRef.set(result);
            }
        };
        Assert.assertSame((Object)original, (Object)contextRef.get());
        contextualizer.contextualize((ExceptionRunnable)exceptionRunner).run();
        Assert.assertSame((Object)original, (Object)contextRef.get());
        Assert.assertSame((Object)result, resultRef.get());
        resultRef.set(null);
        Callable<Object> caller = new Callable<Object>(){

            @Override
            public Object call() {
                Assert.assertSame((Object)target, (Object)contextRef.get());
                return result;
            }
        };
        Assert.assertSame((Object)original, (Object)contextRef.get());
        Assert.assertSame((Object)result, contextualizer.contextualize((Callable)caller).call());
        Assert.assertSame((Object)original, (Object)contextRef.get());
        Supplier<Object> supplier = new Supplier<Object>(){

            @Override
            public Object get() {
                Assert.assertSame((Object)target, (Object)contextRef.get());
                return result;
            }
        };
        Assert.assertSame((Object)original, (Object)contextRef.get());
        Assert.assertSame((Object)result, contextualizer.contextualize((Supplier)supplier).get());
        Assert.assertSame((Object)original, (Object)contextRef.get());
        ExceptionSupplier<Object, Exception> exceptionSupplier = new ExceptionSupplier<Object, Exception>(){

            public Object get() {
                Assert.assertSame((Object)target, (Object)contextRef.get());
                return result;
            }
        };
        Assert.assertSame((Object)original, (Object)contextRef.get());
        Assert.assertSame((Object)result, (Object)contextualizer.contextualize((ExceptionSupplier)exceptionSupplier).get());
        Assert.assertSame((Object)original, (Object)contextRef.get());
    }

    static class AtomicContextReference<T>
    implements ContextReference<T> {
        private AtomicReference<T> ref;

        AtomicContextReference(T initial) {
            this.ref = new AtomicReference<T>(initial);
        }

        public void accept(T value) {
            this.ref.set(value);
        }

        public T get() {
            return this.ref.get();
        }
    }
}

