/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.validation;

import org.jboss.as.clustering.controller.validation.DoubleRangeValidatorBuilder;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class DoubleRangeValidatorTestCase {
    @Test
    public void testFloat() {
        ParameterValidator validator = new DoubleRangeValidatorBuilder().lowerBound((double)1.4E-45f).upperBound(3.4028234663852886E38).build();
        Assert.assertFalse((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode(Double.MAX_VALUE)));
        Assert.assertFalse((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode(Double.MIN_VALUE)));
        Assert.assertTrue((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode(3.4028234663852886E38)));
        Assert.assertTrue((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode((double)1.4E-45f)));
    }

    @Test
    public void testExclusive() {
        boolean lower = false;
        ParameterValidator validator = new DoubleRangeValidatorBuilder().lowerBoundExclusive((double)lower).build();
        Assert.assertFalse((boolean)DoubleRangeValidatorTestCase.isValid(validator, ModelNode.ZERO));
        Assert.assertTrue((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode(0.1)));
        Assert.assertTrue((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode(Double.MAX_VALUE)));
        boolean upper = true;
        validator = new DoubleRangeValidatorBuilder().upperBoundExclusive((double)upper).build();
        Assert.assertTrue((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode(Double.MIN_VALUE)));
        Assert.assertTrue((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode(0.99)));
        Assert.assertFalse((boolean)DoubleRangeValidatorTestCase.isValid(validator, new ModelNode(1)));
    }

    static boolean isValid(ParameterValidator validator, ModelNode value) {
        try {
            validator.validateParameter("test", value);
            return true;
        }
        catch (OperationFailedException e) {
            return false;
        }
    }
}

