/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.transform;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.transform.InitialAttributeValueOperationContextAttachment;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LegacyPropertyWriteOperationTransformer
implements OperationTransformer {
    private final UnaryOperator<PathAddress> addressTransformer;

    public LegacyPropertyWriteOperationTransformer() {
        this(UnaryOperator.identity());
    }

    public LegacyPropertyWriteOperationTransformer(UnaryOperator<PathAddress> addressTransformer) {
        this.addressTransformer = addressTransformer;
    }

    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        if (operation.get("name").asString().equals("properties")) {
            ModelNode newValue;
            InitialAttributeValueOperationContextAttachment attachment = (InitialAttributeValueOperationContextAttachment)context.getAttachment(InitialAttributeValueOperationContextAttachment.INITIAL_VALUES_ATTACHMENT);
            assert (attachment != null);
            PathAddress resolvedAddress = (PathAddress)this.addressTransformer.apply(address);
            ModelNode initialValue = attachment.getInitialValue(resolvedAddress, Operations.getAttributeName(operation));
            if (initialValue.equals(newValue = context.readResourceFromRoot(resolvedAddress).getModel().get("properties").clone()) || initialValue.isDefined() && initialValue.asPropertyList().isEmpty() && !newValue.isDefined()) {
                return new OperationTransformer.TransformedOperation(null, DEFAULT_REJECTION_POLICY, SUCCESSFUL_RESULT);
            }
            HashMap<String, ModelNode> oldMap = new HashMap<String, ModelNode>();
            if (initialValue.isDefined()) {
                for (Property property : initialValue.asPropertyList()) {
                    oldMap.put(property.getName(), property.getValue());
                }
            }
            PathAddress legacyAddress = Operations.getPathAddress(operation);
            LinkedList<ModelNode> operations = new LinkedList<ModelNode>();
            if (newValue.isDefined()) {
                for (Property property : newValue.asPropertyList()) {
                    String key = property.getName();
                    ModelNode value = property.getValue();
                    if (!oldMap.containsKey(key)) {
                        ModelNode addOp = Util.createAddOperation((PathAddress)legacyAddress.append(new PathElement[]{PathElement.pathElement((String)"property", (String)key)}));
                        addOp.get("value").set(value);
                        operations.add(addOp);
                        continue;
                    }
                    ModelNode oldPropValue = (ModelNode)oldMap.get(key);
                    if (!oldPropValue.equals(value)) {
                        ModelNode writeOp = Util.getWriteAttributeOperation((PathAddress)legacyAddress.append(new PathElement[]{PathElement.pathElement((String)"property", (String)key)}), (String)"value", (ModelNode)value);
                        operations.add(writeOp);
                    }
                    oldMap.remove(key);
                }
            }
            for (Map.Entry entry : oldMap.entrySet()) {
                ModelNode removeOperation = Util.createRemoveOperation((PathAddress)legacyAddress.append(new PathElement[]{PathElement.pathElement((String)"property", (String)((String)entry.getKey()))}));
                operations.add(removeOperation);
            }
            initialValue.set(newValue.clone());
            return new OperationTransformer.TransformedOperation(Operations.createCompositeOperation(operations), OperationResultTransformer.ORIGINAL_RESULT);
        }
        return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
    }
}

