/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.io.InputStream;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class PropertiesTestUtil {
    private PropertiesTestUtil() {
    }

    public static void checkMapResults(KernelServices services, ModelNode expected, ModelVersion version, ModelNode operation) throws Exception {
        ModelNode legacy;
        ModelNode main = ModelTestUtils.checkOutcome((ModelNode)services.executeOperation(operation.clone(), new InputStream[0])).get("result");
        ModelNode legacyResult = services.executeOperation(version, services.transformOperation(version, operation.clone()));
        if (expected.isDefined()) {
            legacy = ModelTestUtils.checkOutcome((ModelNode)legacyResult).get("result");
        } else {
            ModelTestUtils.checkFailed((ModelNode)legacyResult);
            legacy = new ModelNode();
        }
        Assert.assertEquals((Object)main, (Object)legacy);
        Assert.assertEquals((Object)expected, (Object)legacy);
    }

    public static void checkMainMapModel(ModelNode model, String ... properties) {
        Assert.assertEquals((long)0L, (long)(properties.length % 2));
        ModelNode props = model.get("properties");
        Assert.assertEquals((long)(properties.length / 2), (long)(props.isDefined() ? (long)props.keys().size() : 0L));
        for (int i = 0; i < properties.length; i += 2) {
            Assert.assertEquals((Object)properties[i + 1], (Object)props.get(properties[i]).asString());
        }
    }

    public static void checkLegacyChildResourceModel(ModelNode model, String ... properties) {
        Assert.assertEquals((long)0L, (long)(properties.length % 2));
        ModelNode props = model.get("property");
        Assert.assertEquals((long)(properties.length / 2), (long)(props.isDefined() ? (long)props.keys().size() : 0L));
        for (int i = 0; i < properties.length; i += 2) {
            ModelNode property = props.get(properties[i]);
            Assert.assertTrue((boolean)property.isDefined());
            Assert.assertEquals((long)1L, (long)property.keys().size());
            Assert.assertEquals((Object)properties[i + 1], (Object)property.get("value").asString());
        }
    }

    public static void checkMapModels(KernelServices services, ModelVersion version, PathAddress address, String ... properties) throws Exception {
        ModelNode legacyModel;
        ModelNode readResource = Util.createEmptyOperation((String)"read-resource", (PathAddress)address);
        readResource.get("recursive").set(true);
        readResource.get("include-defaults").set(false);
        ModelNode mainModel = services.executeForResult(readResource.clone(), new InputStream[0]);
        PropertiesTestUtil.checkMainMapModel(mainModel, properties);
        if (address.getLastElement().getKey().equals("transport")) {
            readResource.get("address").set(address.subAddress(0, address.size() - 1).append("transport", "TRANSPORT").toModelNode());
            legacyModel = ((KernelServices)services.getLegacyServices(version)).executeForResult(readResource, new InputStream[0]);
        } else {
            legacyModel = ModelTestUtils.checkResultAndGetContents((ModelNode)services.executeOperation(version, services.transformOperation(version, readResource.clone())));
        }
        PropertiesTestUtil.checkLegacyChildResourceModel(legacyModel, properties);
    }

    public static ModelNode success() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("success");
        result.get("result");
        return result;
    }

    public static ModelNode executeOpInBothControllersWithAttachments(KernelServices services, ModelVersion version, ModelNode operation) throws Exception {
        OperationTransformer.TransformedOperation op = services.executeInMainAndGetTheTransformedOperation(operation, version);
        Assert.assertFalse((boolean)op.rejectOperation(PropertiesTestUtil.success()));
        if (op.getTransformedOperation() != null) {
            return ModelTestUtils.checkOutcome((ModelNode)((KernelServices)services.getLegacyServices(version)).executeOperation(op.getTransformedOperation(), new InputStream[0]));
        }
        return null;
    }
}

