/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.validation;

import org.jboss.as.clustering.controller.validation.DoubleRangeValidator;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class DoubleRangeValidatorTestCase {
    @Test
    public void testDouble() {
        ParameterValidator validator = DoubleRangeValidator.NON_NEGATIVE;
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(Double.MAX_VALUE));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(Double.MIN_VALUE));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(0.0));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-4.9E-324));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-1.7976931348623157E308));
        validator = DoubleRangeValidator.POSITIVE;
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(Double.MAX_VALUE));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(Double.MIN_VALUE));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(0.0));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-4.9E-324));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-1.7976931348623157E308));
        validator = new DoubleRangeValidator(DoubleRangeValidator.Bound.exclusive((double)0.0), DoubleRangeValidator.Bound.exclusive((double)1.0));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(Double.MAX_VALUE));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(1.0));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(0.9999999999999999));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(Double.MIN_VALUE));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(0.0));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-4.9E-324));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-1.7976931348623157E308));
    }

    @Test
    public void testFloat() {
        ParameterValidator validator = DoubleRangeValidator.FLOAT;
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(Double.MAX_VALUE));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(3.4028234663852886E38));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode((double)1.4E-45f));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(Double.MIN_VALUE));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(0.0));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(-4.9E-324));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode((double)-1.4E-45f));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(-3.4028234663852886E38));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-1.7976931348623157E308));
        validator = DoubleRangeValidator.NON_NEGATIVE_FLOAT;
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(Double.MAX_VALUE));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(3.4028234663852886E38));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode((double)1.4E-45f));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(Double.MIN_VALUE));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(0.0));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-4.9E-324));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode((double)-1.4E-45f));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-3.4028234663852886E38));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-1.7976931348623157E308));
        validator = DoubleRangeValidator.POSITIVE_FLOAT;
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(Double.MAX_VALUE));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode(3.4028234663852886E38));
        DoubleRangeValidatorTestCase.assertValid(validator, new ModelNode((double)1.4E-45f));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(Double.MIN_VALUE));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(0.0));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-4.9E-324));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode((double)-1.4E-45f));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-3.4028234663852886E38));
        DoubleRangeValidatorTestCase.assertInvalid(validator, new ModelNode(-1.7976931348623157E308));
    }

    static void assertValid(ParameterValidator validator, ModelNode value) {
        try {
            validator.validateParameter("test", value);
        }
        catch (OperationFailedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    static void assertInvalid(ParameterValidator validator, ModelNode value) {
        Assert.assertThrows(OperationFailedException.class, () -> validator.validateParameter("test", value));
    }
}

