/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshalledValue;
import org.jboss.as.clustering.marshalling.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContext;
import org.jboss.as.clustering.marshalling.VersionedMarshallingConfiguration;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class SimpleMarshalledValueFactoryTestCase {
    private final MarshallingContext context;
    private final SimpleMarshalledValueFactory factory;

    public SimpleMarshalledValueFactoryTestCase() {
        VersionedMarshallingConfiguration configuration = new VersionedMarshallingConfiguration(){

            public int getCurrentMarshallingVersion() {
                return 0;
            }

            public MarshallingConfiguration getMarshallingConfiguration(int version) {
                Assert.assertEquals((long)0L, (long)version);
                return new MarshallingConfiguration();
            }
        };
        this.context = new SimpleMarshallingContext(Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Marshalling.class.getClassLoader()), configuration, Thread.currentThread().getContextClassLoader());
        this.factory = this.createFactory(this.context);
    }

    SimpleMarshalledValueFactory createFactory(MarshallingContext context) {
        return new SimpleMarshalledValueFactory(context);
    }

    @Test
    public void get() throws Exception {
        UUID uuid = UUID.randomUUID();
        SimpleMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assert.assertNotNull((Object)mv.peek());
        Assert.assertSame((Object)uuid, (Object)mv.peek());
        Assert.assertSame((Object)uuid, (Object)mv.get(this.context));
        SimpleMarshalledValue copy = this.replicate(mv);
        Assert.assertNull((Object)copy.peek());
        UUID uuid2 = (UUID)copy.get(this.context);
        Assert.assertNotSame((Object)uuid, (Object)uuid2);
        Assert.assertEquals((Object)uuid, (Object)uuid2);
        copy = this.replicate(copy);
        uuid2 = (UUID)copy.get(this.context);
        Assert.assertEquals((Object)uuid, (Object)uuid2);
        mv = this.factory.createMarshalledValue(null);
        Assert.assertNull((Object)mv.peek());
        Assert.assertNull((Object)mv.getBytes());
        Assert.assertNull((Object)mv.get(this.context));
    }

    @Test
    public void equals() throws Exception {
        UUID uuid = UUID.randomUUID();
        SimpleMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assert.assertTrue((boolean)mv.equals((Object)mv));
        Assert.assertFalse((boolean)mv.equals(null));
        SimpleMarshalledValue dup = this.factory.createMarshalledValue((Object)uuid);
        Assert.assertTrue((boolean)mv.equals((Object)dup));
        Assert.assertTrue((boolean)dup.equals((Object)mv));
        SimpleMarshalledValue replica = this.replicate(mv);
        Assert.assertTrue((boolean)mv.equals(replica));
        Assert.assertTrue((boolean)replica.equals((Object)mv));
        SimpleMarshalledValue nulled = this.factory.createMarshalledValue(null);
        Assert.assertFalse((boolean)mv.equals((Object)nulled));
        Assert.assertFalse((boolean)nulled.equals((Object)mv));
        Assert.assertFalse((boolean)replica.equals((Object)nulled));
        Assert.assertFalse((boolean)nulled.equals(replica));
        Assert.assertTrue((boolean)nulled.equals((Object)nulled));
        Assert.assertFalse((boolean)nulled.equals(null));
        Assert.assertTrue((boolean)nulled.equals((Object)this.factory.createMarshalledValue(null)));
    }

    @Test
    public void testHashCode() throws Exception {
        UUID uuid = UUID.randomUUID();
        SimpleMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assert.assertEquals((long)uuid.hashCode(), (long)mv.hashCode());
        SimpleMarshalledValue copy = this.replicate(mv);
        this.validateHashCode(uuid, copy);
        mv = this.factory.createMarshalledValue(null);
        Assert.assertEquals((long)0L, (long)mv.hashCode());
    }

    <T> void validateHashCode(T original, SimpleMarshalledValue<T> copy) {
        Assert.assertEquals((long)0L, (long)copy.hashCode());
    }

    <V> SimpleMarshalledValue<V> replicate(SimpleMarshalledValue<V> mv) throws IOException, ClassNotFoundException {
        return (SimpleMarshalledValue)SimpleMarshalledValueFactoryTestCase.unmarshall(SimpleMarshalledValueFactoryTestCase.marshall(mv));
    }

    private static byte[] marshall(Object mv) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(mv);
        oos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object unmarshall(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object object = ois.readObject();
            return object;
        }
    }
}

