/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.clustering.concurrent.ManagedExecutorService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ManagedExecutorServiceTest {
    private final ExecutorService executor;
    private final ExecutorService subject;

    public ManagedExecutorServiceTest() {
        this((ExecutorService)Mockito.mock(ExecutorService.class));
    }

    private ManagedExecutorServiceTest(ExecutorService executor) {
        this(executor, (ExecutorService)new ManagedExecutorService(executor));
    }

    protected ManagedExecutorServiceTest(ExecutorService executor, ExecutorService subject) {
        this.executor = executor;
        this.subject = subject;
    }

    @Test
    public void submitCallable() {
        Future expected = (Future)Mockito.mock(Future.class);
        Task task = new Task();
        Mockito.when(this.executor.submit(task)).thenReturn((Object)expected);
        Future<Object> result = this.subject.submit(task);
        Assert.assertSame((Object)expected, result);
    }

    @Test
    public void submitRunnable() {
        Future expected = (Future)Mockito.mock(Future.class);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        Mockito.when(this.executor.submit(task)).thenReturn((Object)expected);
        Future<?> result = this.subject.submit(task);
        Assert.assertSame((Object)expected, result);
    }

    @Test
    public void submitRunnableWithResult() {
        Future expected = (Future)Mockito.mock(Future.class);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        Object r = new Object();
        Mockito.when(this.executor.submit(task, r)).thenReturn((Object)expected);
        Future<Object> result = this.subject.submit(task, r);
        Assert.assertSame((Object)expected, result);
    }

    @Test
    public void execute() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        this.subject.execute(task);
        ((ExecutorService)Mockito.verify((Object)this.executor)).execute(task);
    }

    @Test
    public void invokeAll() throws InterruptedException {
        List<Task> tasks = Collections.singletonList(new Task());
        Future future = (Future)Mockito.mock(Future.class);
        List<Future> expected = Collections.singletonList(future);
        Mockito.when(this.executor.invokeAll(tasks)).thenReturn(expected);
        List result = this.subject.invokeAll(tasks);
        Assert.assertSame(expected, result);
    }

    @Test
    public void invokeAllWithTimeout() throws InterruptedException {
        List<Task> tasks = Collections.singletonList(new Task());
        Future future = (Future)Mockito.mock(Future.class);
        List<Future> expected = Collections.singletonList(future);
        long timeout = 10L;
        TimeUnit unit = TimeUnit.SECONDS;
        Mockito.when(this.executor.invokeAll(tasks, timeout, unit)).thenReturn(expected);
        List result = this.subject.invokeAll(tasks, timeout, unit);
        Assert.assertSame(expected, result);
    }

    @Test
    public void invokeAny() throws InterruptedException, ExecutionException {
        List<Task> tasks = Collections.singletonList(new Task());
        Object expected = new Object();
        Mockito.when(this.executor.invokeAny(tasks)).thenReturn(expected);
        Object result = this.subject.invokeAny(tasks);
        Assert.assertSame((Object)expected, result);
    }

    @Test
    public void invokeAnyWithTimeout() throws InterruptedException, ExecutionException, TimeoutException {
        List<Task> tasks = Collections.singletonList(new Task());
        Object expected = new Object();
        long timeout = 10L;
        TimeUnit unit = TimeUnit.SECONDS;
        Mockito.when(this.executor.invokeAny(tasks, timeout, unit)).thenReturn(expected);
        Object result = this.subject.invokeAny(tasks, timeout, unit);
        Assert.assertSame((Object)expected, result);
    }

    @Test
    public void shutdown() {
        this.subject.shutdown();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executor});
    }

    @Test
    public void shutdownNow() {
        List<Runnable> result = this.subject.shutdownNow();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executor});
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void isShutdown() {
        Mockito.when((Object)this.executor.isShutdown()).thenReturn((Object)true);
        boolean result = this.subject.isShutdown();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void isTerminated() {
        Mockito.when((Object)this.executor.isTerminated()).thenReturn((Object)true);
        boolean result = this.subject.isTerminated();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void awaitTermination() throws InterruptedException {
        Mockito.when((Object)this.executor.isTerminated()).thenReturn((Object)true);
        boolean result = this.subject.awaitTermination(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)result);
    }

    static class Task
    implements Callable<Object> {
        Task() {
        }

        @Override
        public Object call() throws Exception {
            return null;
        }
    }
}

