/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class OperationHandler<C>
extends AbstractRuntimeOnlyHandler
implements Registration {
    private final Map<String, Operation<C>> operations = new HashMap<String, Operation<C>>();
    private final OperationExecutor<C> executor;

    public <O extends Enum<O>> OperationHandler(OperationExecutor<C> executor, Class<O> operationClass) {
        this(executor, (Operation[])operationClass.getEnumConstants());
    }

    public OperationHandler(OperationExecutor<C> executor, Operation<C>[] operations) {
        this(executor, Arrays.asList(operations));
    }

    public OperationHandler(OperationExecutor<C> executor, Iterable<Operation<C>> operations) {
        this.executor = executor;
        for (Operation<C> operation : operations) {
            this.operations.put(operation.getDefinition().getName(), operation);
        }
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        for (Operation<C> operation : this.operations.values()) {
            registration.registerOperationHandler(operation.getDefinition(), (OperationStepHandler)this);
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode op) {
        String name = Operations.getName(op);
        Operation<C> operation = this.operations.get(name);
        try {
            ModelNode result = this.executor.execute(context, operation);
            if (result != null) {
                context.getResult().set(result);
            }
        }
        catch (OperationFailedException e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

