/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.offset;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.cache.offset.Offset;

public class OffsetTestCase {
    @Test
    public void duration() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Offset offset = Offset.forDuration((Duration)Duration.ZERO);
        Assert.assertSame((Object)backward, (Object)offset.apply((Object)backward));
        Assert.assertSame((Object)Duration.ZERO, (Object)offset.apply((Object)Duration.ZERO));
        Assert.assertSame((Object)forward, (Object)offset.apply((Object)forward));
        offset = Offset.forDuration((Duration)forward);
        Assert.assertEquals((Object)Duration.ZERO, (Object)offset.apply((Object)backward));
        Assert.assertEquals((Object)forward, (Object)offset.apply((Object)Duration.ZERO));
        offset = Offset.forDuration((Duration)backward);
        Assert.assertEquals((Object)backward, (Object)offset.apply((Object)Duration.ZERO));
        Assert.assertEquals((Object)Duration.ZERO, (Object)offset.apply((Object)forward));
    }

    @Test
    public void instant() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Instant present = Instant.now();
        Instant past = present.plus(backward);
        Instant future = present.plus(forward);
        Offset offset = Offset.forInstant((Duration)Duration.ZERO);
        Assert.assertSame((Object)past, (Object)offset.apply((Object)past));
        Assert.assertSame((Object)present, (Object)offset.apply((Object)present));
        Assert.assertSame((Object)future, (Object)offset.apply((Object)future));
        offset = Offset.forInstant((Duration)forward);
        Assert.assertEquals((Object)present, (Object)offset.apply((Object)past));
        Assert.assertEquals((Object)future, (Object)offset.apply((Object)present));
        offset = Offset.forInstant((Duration)backward);
        Assert.assertEquals((Object)past, (Object)offset.apply((Object)present));
        Assert.assertEquals((Object)present, (Object)offset.apply((Object)future));
    }
}

