/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.transaction.TransactionMode;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;

public class CacheEntryMutatorTestCase {
    @Test
    public void mutateTransactional() {
        AdvancedCache cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        Object id = new Object();
        Object value = new Object();
        Configuration config = new ConfigurationBuilder().transaction().transactionMode(TransactionMode.TRANSACTIONAL).build();
        Mockito.when((Object)cache.getCacheConfiguration()).thenReturn((Object)config);
        CacheEntryMutator mutator = new CacheEntryMutator((Cache)cache, id, value);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn((Object)cache);
        Mockito.when((Object)cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY})).thenReturn((Object)cache);
        mutator.mutate();
        ((AdvancedCache)Mockito.verify((Object)cache)).put(ArgumentMatchers.same((Object)id), ArgumentMatchers.same((Object)value));
        mutator.mutate();
        ((AdvancedCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)1))).put(ArgumentMatchers.same((Object)id), ArgumentMatchers.same((Object)value));
        mutator.mutate();
        ((AdvancedCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)1))).put(ArgumentMatchers.same((Object)id), ArgumentMatchers.same((Object)value));
    }

    @Test
    public void mutateNonTransactional() {
        AdvancedCache cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        Object id = new Object();
        Object value = new Object();
        Configuration config = new ConfigurationBuilder().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).build();
        Mockito.when((Object)cache.getCacheConfiguration()).thenReturn((Object)config);
        CacheEntryMutator mutator = new CacheEntryMutator((Cache)cache, id, value);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn((Object)cache);
        Mockito.when((Object)cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY})).thenReturn((Object)cache);
        mutator.mutate();
        ((AdvancedCache)Mockito.verify((Object)cache)).put(ArgumentMatchers.same((Object)id), ArgumentMatchers.same((Object)value));
        mutator.mutate();
        ((AdvancedCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)2))).put(ArgumentMatchers.same((Object)id), ArgumentMatchers.same((Object)value));
        mutator.mutate();
        ((AdvancedCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.times((int)3))).put(ArgumentMatchers.same((Object)id), ArgumentMatchers.same((Object)value));
    }
}

