/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.expiration.ExpirationMetaData;

public class ExpirationMetaDataTestCase {
    @Test
    public void nullTimeout() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return null;
            }

            public Instant getLastAccessTime() {
                return Instant.now().plus(Duration.ofHours(1L));
            }
        };
        Assert.assertFalse((boolean)metaData.isExpired());
        Assert.assertTrue((boolean)metaData.isImmortal());
    }

    @Test
    public void negativeTimeout() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return Duration.ofSeconds(-1L);
            }

            public Instant getLastAccessTime() {
                return Instant.now().plus(Duration.ofHours(1L));
            }
        };
        Assert.assertFalse((boolean)metaData.isExpired());
        Assert.assertTrue((boolean)metaData.isImmortal());
    }

    @Test
    public void zeroTimeout() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return Duration.ZERO;
            }

            public Instant getLastAccessTime() {
                return Instant.now().plus(Duration.ofHours(1L));
            }
        };
        Assert.assertFalse((boolean)metaData.isExpired());
        Assert.assertTrue((boolean)metaData.isImmortal());
    }

    @Test
    public void expired() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return Duration.ofMinutes(1L);
            }

            public Instant getLastAccessTime() {
                return Instant.now().minus(Duration.ofHours(1L));
            }
        };
        Assert.assertTrue((boolean)metaData.isExpired());
        Assert.assertFalse((boolean)metaData.isImmortal());
    }

    @Test
    public void notYetExpired() {
        ExpirationMetaData metaData = new ExpirationMetaData(){

            public Duration getTimeout() {
                return Duration.ofHours(1L);
            }

            public Instant getLastAccessTime() {
                return Instant.now();
            }
        };
        Assert.assertFalse((boolean)metaData.isExpired());
        Assert.assertFalse((boolean)metaData.isImmortal());
    }
}

