/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanGroup;
import org.wildfly.clustering.ejb.cache.bean.CompositeImmutableBean;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;

public class CompositeBean<K, V extends BeanInstance<K>>
extends CompositeImmutableBean<K, V>
implements MutableBean<K, V> {
    private final BeanMetaData<K> metaData;
    private final BeanGroup<K, V> group;
    private final Remover<K> remover;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public CompositeBean(K id, BeanMetaData<K> metaData, BeanGroup<K, V> group, Remover<K> remover) {
        super(id, group.getBeanInstance(id), metaData);
        this.metaData = metaData;
        this.group = group;
        this.remover = remover;
    }

    @Override
    public BeanMetaData<K> getMetaData() {
        return this.metaData;
    }

    @Override
    public void setInstance(V instance) {
        this.group.addBeanInstance(instance);
    }

    public boolean isValid() {
        return this.valid.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Consumer<V> removeTask) {
        if (this.valid.compareAndSet(true, false)) {
            try {
                Object id = this.getId();
                V instance = this.group.removeBeanInstance(id);
                this.remover.remove(id);
                if (instance != null) {
                    removeTask.accept(instance);
                }
            }
            finally {
                this.group.close();
            }
        }
    }

    public void close() {
        if (this.valid.compareAndSet(true, false)) {
            this.group.close();
        }
    }
}

