/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.ejb3.cache.backing.infinispan;

import java.io.Serializable;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.ejb3.cache.backing.infinispan.ClusterNameService;
import org.jboss.as.clustering.ejb3.cache.backing.infinispan.InfinispanBackingCacheEntryStore;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.invoker.BatchCacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.marshalling.MarshalledValueFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContextFactory;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.IdentifierFactory;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.remote.EJBRemotingConnectorClientMappingsEntryProviderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;

public class InfinispanBackingCacheEntryStoreSource<K extends Serializable, V extends Cacheable<K>, G extends Serializable>
extends AbstractBackingCacheEntryStoreSource<K, V, G>
implements ClusteredBackingCacheEntryStoreSource<K, V, G> {
    private String cacheContainerName = "ejb";
    private String beanCacheName = DEFAULT_BEAN_CACHE;
    private String clientMappingsCacheName = "remote-connector-client-mappings";
    private int maxSize = 10000;
    private boolean passivateEventsOnReplicate = true;
    private CacheInvoker invoker = new RetryingCacheInvoker((CacheInvoker)new BatchCacheInvoker(), new int[]{10, 100});
    private final InjectedValue<Cache> groupCache = new InjectedValue();
    private final InjectedValue<Registry> registry = new InjectedValue();
    private final InjectedValue<NodeFactory> nodeFactory = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();

    public void addDependencies(ServiceTarget target, ServiceBuilder<?> builder) {
        ServiceName groupCacheServiceName = CacheService.getServiceName((String)this.cacheContainerName, (String)this.beanCacheName);
        builder.addDependency(groupCacheServiceName, Cache.class, this.groupCache);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"clustering", "registry", this.cacheContainerName, this.clientMappingsCacheName}), Registry.class, this.registry);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"clustering", "nodes", this.cacheContainerName, this.clientMappingsCacheName}), NodeFactory.class, this.nodeFactory);
        builder.addDependency(KeyAffinityServiceFactoryService.getServiceName((String)this.cacheContainerName), KeyAffinityServiceFactory.class, this.affinityFactory);
        InjectedValue registryEntryProvider = new InjectedValue();
        target.addService(ServiceName.JBOSS.append(new String[]{"clustering", "registry", this.cacheContainerName, this.clientMappingsCacheName, "entry"}), (Service)new ValueService((Value)registryEntryProvider)).addDependency(EJBRemotingConnectorClientMappingsEntryProviderService.SERVICE_NAME, RegistryEntryProvider.class, (Injector)registryEntryProvider).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        InjectedValue container = new InjectedValue();
        target.addService(ClusteredBackingCacheEntryStoreSourceService.getCacheContainerClusterNameServiceName((String)this.cacheContainerName), (Service)new ClusterNameService((Value<EmbeddedCacheManager>)container)).addDependency(EmbeddedCacheManagerService.getServiceName((String)this.cacheContainerName), EmbeddedCacheManager.class, (Injector)container).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    public <E extends SerializationGroup<K, V, G>> BackingCacheEntryStore<G, Cacheable<G>, E> createGroupIntegratedObjectStore(IdentifierFactory<G> identifierFactory, PassivationManager<G, E> passivationManager, StatefulTimeoutInfo timeout) {
        Cache cache = (Cache)this.groupCache.getValue();
        SimpleMarshallingContext context = new SimpleMarshallingContextFactory().createMarshallingContext(passivationManager, passivationManager.getClassLoader());
        SimpleMarshalledValueFactory valueFactory = new SimpleMarshalledValueFactory((MarshallingContext)context);
        Registry registry = (Registry)this.registry.getOptionalValue();
        NodeFactory nodeFactory = (NodeFactory)this.nodeFactory.getOptionalValue();
        return new InfinispanBackingCacheEntryStore(cache, this.invoker, identifierFactory, (KeyAffinityServiceFactory)this.affinityFactory.getValue(), null, timeout, (ClusteredBackingCacheEntryStoreConfig)this, false, (MarshalledValueFactory<SimpleMarshallingContext>)valueFactory, context, (NodeFactory<Address>)nodeFactory, (Registry<String, ?>)registry);
    }

    public <E extends SerializationGroupMember<K, V, G>> BackingCacheEntryStore<K, V, E> createIntegratedObjectStore(String beanName, IdentifierFactory<K> identifierFactory, PassivationManager<K, E> passivationManager, StatefulTimeoutInfo timeout) {
        Cache groupCache = (Cache)this.groupCache.getValue();
        Configuration groupCacheConfiguration = groupCache.getCacheConfiguration();
        EmbeddedCacheManager container = groupCache.getCacheManager();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(groupCacheConfiguration);
        builder.storeAsBinary().enable().storeKeysAsBinary(true).storeValuesAsBinary(false);
        if (this.maxSize > 0) {
            if (!groupCacheConfiguration.eviction().strategy().isEnabled()) {
                builder.eviction().strategy(EvictionStrategy.LRU);
            }
            builder.eviction().maxEntries(this.maxSize);
        }
        groupCache.getCacheManager().defineConfiguration(beanName, builder.build());
        Cache cache = container.getCache(beanName);
        SimpleMarshallingContext context = new SimpleMarshallingContextFactory().createMarshallingContext(passivationManager, passivationManager.getClassLoader());
        SimpleMarshalledValueFactory valueFactory = new SimpleMarshalledValueFactory((MarshallingContext)context);
        NodeFactory nodeFactory = (NodeFactory)this.nodeFactory.getOptionalValue();
        Registry registry = (Registry)this.registry.getOptionalValue();
        return new InfinispanBackingCacheEntryStore(cache, this.invoker, identifierFactory, (KeyAffinityServiceFactory)this.affinityFactory.getValue(), this.passivateEventsOnReplicate ? passivationManager : null, timeout, (ClusteredBackingCacheEntryStoreConfig)this, true, (MarshalledValueFactory<SimpleMarshallingContext>)valueFactory, context, (NodeFactory<Address>)nodeFactory, (Registry<String, ?>)registry);
    }

    public void setKeyAffinityServiceFactory(KeyAffinityServiceFactory affinityFactory) {
        this.affinityFactory.inject((Object)affinityFactory);
    }

    public String getCacheContainer() {
        return this.cacheContainerName;
    }

    public void setCacheContainer(String cacheContainerName) {
        this.cacheContainerName = cacheContainerName;
    }

    public String getClientMappingCache() {
        return this.clientMappingsCacheName;
    }

    public void setClientMappingCache(String cacheName) {
        this.clientMappingsCacheName = cacheName;
    }

    public String getBeanCache() {
        return this.beanCacheName;
    }

    public void setBeanCache(String cacheName) {
        this.beanCacheName = cacheName;
    }

    public boolean isPassivateEventsOnReplicate() {
        return this.passivateEventsOnReplicate;
    }

    public void setPassivateEventsOnReplicate(boolean passivateEventsOnReplicate) {
        this.passivateEventsOnReplicate = passivateEventsOnReplicate;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void started() {
    }

    public void stopped() {
    }
}

