/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.persistence;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.infinispan.persistence.IndexedKeyFormatMapper;
import org.wildfly.clustering.marshalling.spi.Formatter;
import org.wildfly.clustering.marshalling.spi.SimpleFormatter;

public class IndexedKeyFormatMapperTestCase {
    @Test
    public void testSinglePadding() {
        IndexedKeyFormatMapper mapper = new IndexedKeyFormatMapper(IndexedKeyFormatMapperTestCase.createPersistenceList(16));
        Assert.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE00)).getClass()));
        Assert.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE15)).getClass()));
        Assert.assertFalse((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE16)).getClass()));
        Assert.assertFalse((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE17)).getClass()));
        String result = mapper.getStringMapping((Object)Type.TYPE00);
        Assert.assertSame((Object)((Object)Type.TYPE00), (Object)mapper.getKeyMapping(result));
        Assert.assertEquals((Object)"0TYPE00", (Object)result);
        result = mapper.getStringMapping((Object)Type.TYPE15);
        Assert.assertSame((Object)((Object)Type.TYPE15), (Object)mapper.getKeyMapping(result));
        Assert.assertEquals((Object)"FTYPE15", (Object)result);
    }

    @Test
    public void testDoublePadding() {
        IndexedKeyFormatMapper mapper = new IndexedKeyFormatMapper(IndexedKeyFormatMapperTestCase.createPersistenceList(17));
        Assert.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE00)).getClass()));
        Assert.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE15)).getClass()));
        Assert.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE16)).getClass()));
        Assert.assertFalse((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE17)).getClass()));
        String result = mapper.getStringMapping((Object)Type.TYPE00);
        Assert.assertSame((Object)((Object)Type.TYPE00), (Object)mapper.getKeyMapping(result));
        Assert.assertEquals((Object)"00TYPE00", (Object)result);
        result = mapper.getStringMapping((Object)Type.TYPE15);
        Assert.assertSame((Object)((Object)Type.TYPE15), (Object)mapper.getKeyMapping(result));
        Assert.assertEquals((Object)"0FTYPE15", (Object)result);
        result = mapper.getStringMapping((Object)Type.TYPE16);
        Assert.assertSame((Object)((Object)Type.TYPE16), (Object)mapper.getKeyMapping(result));
        Assert.assertEquals((Object)"10TYPE16", (Object)result);
    }

    private static List<? extends Formatter<?>> createPersistenceList(int size) {
        return IntStream.range(0, size).mapToObj(index -> new SimpleFormatter(((Object)((Object)Type.values()[index])).getClass(), value -> Type.valueOf(value), Enum::name)).collect(Collectors.toList());
    }

    static enum Type {
        TYPE00{}
        ,
        TYPE01{}
        ,
        TYPE02{}
        ,
        TYPE03{}
        ,
        TYPE04{}
        ,
        TYPE05{}
        ,
        TYPE06{}
        ,
        TYPE07{}
        ,
        TYPE08{}
        ,
        TYPE09{}
        ,
        TYPE10{}
        ,
        TYPE11{}
        ,
        TYPE12{}
        ,
        TYPE13{}
        ,
        TYPE14{}
        ,
        TYPE15{}
        ,
        TYPE16{}
        ,
        TYPE17{};

    }
}

