/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.affinity.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.wildfly.clustering.infinispan.affinity.impl.DefaultKeyAffinityService;

public class DefaultKeyAffinityServiceTestCase {
    private static final int SEGMENTS = 3;
    private static final int LOCAL_SEGMENT = 0;
    private static final int REMOTE_SEGMENT = 1;
    private static final int FILTERED_SEGMENT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        KeyPartitioner partitioner = (KeyPartitioner)Mockito.mock(KeyPartitioner.class);
        KeyGenerator generator = (KeyGenerator)Mockito.mock(KeyGenerator.class);
        AdvancedCache cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        Address local = (Address)Mockito.mock(Address.class);
        Address remote = (Address)Mockito.mock(Address.class);
        Address standby = (Address)Mockito.mock(Address.class);
        Address ignored = (Address)Mockito.mock(Address.class);
        DefaultKeyAffinityService service = new DefaultKeyAffinityService((Cache)cache, partitioner, generator, address -> address != ignored);
        DistributionManager dist = (DistributionManager)Mockito.mock(DistributionManager.class);
        CacheTopology topology = (CacheTopology)Mockito.mock(CacheTopology.class);
        ConsistentHash hash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        List<Address> members = Arrays.asList(local, remote, standby, ignored);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn((Object)cache);
        Mockito.when((Object)cache.getDistributionManager()).thenReturn((Object)dist);
        Mockito.when((Object)topology.getActualMembers()).thenReturn(members);
        Mockito.when((Object)topology.getCurrentCH()).thenReturn((Object)hash);
        Mockito.when((Object)topology.getMembers()).thenReturn(members);
        Mockito.when((Object)topology.getMembersPersistentUUIDs()).thenReturn(Arrays.asList(PersistentUUID.randomUUID(), PersistentUUID.randomUUID(), PersistentUUID.randomUUID(), PersistentUUID.randomUUID()));
        Mockito.when((Object)topology.getPendingCH()).thenReturn(null);
        Mockito.when((Object)topology.getPhase()).thenReturn((Object)CacheTopology.Phase.NO_REBALANCE);
        Mockito.when((Object)topology.getReadConsistentHash()).thenReturn((Object)hash);
        Mockito.when((Object)topology.getRebalanceId()).thenReturn((Object)0);
        Mockito.when((Object)topology.getTopologyId()).thenReturn((Object)0);
        Mockito.when((Object)topology.getUnionCH()).thenReturn(null);
        Mockito.when((Object)topology.getWriteConsistentHash()).thenReturn((Object)hash);
        Mockito.when((Object)hash.getMembers()).thenReturn(members);
        Mockito.when((Object)hash.getNumSegments()).thenReturn((Object)3);
        Mockito.when((Object)hash.locatePrimaryOwnerForSegment(0)).thenReturn((Object)local);
        Mockito.when((Object)hash.locatePrimaryOwnerForSegment(1)).thenReturn((Object)remote);
        Mockito.when((Object)hash.locatePrimaryOwnerForSegment(2)).thenReturn((Object)ignored);
        Mockito.when((Object)hash.locateOwnersForSegment(0)).thenReturn(Collections.singletonList(local));
        Mockito.when((Object)hash.locateOwnersForSegment(1)).thenReturn(Collections.singletonList(remote));
        Mockito.when((Object)hash.locateOwnersForSegment(2)).thenReturn(Collections.singletonList(ignored));
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(local)).thenReturn(Collections.singleton(0));
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(remote)).thenReturn(Collections.singleton(1));
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(standby)).thenReturn(Collections.emptySet());
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(ignored)).thenReturn(Collections.singleton(2));
        Mockito.when((Object)hash.getSegmentsForOwner(local)).thenReturn(Collections.singleton(0));
        Mockito.when((Object)hash.getSegmentsForOwner(remote)).thenReturn(Collections.singleton(1));
        Mockito.when((Object)hash.getSegmentsForOwner(standby)).thenReturn(Collections.emptySet());
        Mockito.when((Object)hash.getSegmentsForOwner(ignored)).thenReturn(Collections.singleton(2));
        LocalizedCacheTopology localizedTopology = new LocalizedCacheTopology(CacheMode.DIST_SYNC, topology, partitioner, local, true);
        Mockito.when((Object)dist.getCacheTopology()).thenReturn((Object)localizedTopology);
        int[] keysPerSegment = new int[3];
        Arrays.fill(keysPerSegment, 0);
        int minKeysPerSegment = 300;
        IntPredicate needMoreKeys = keys -> keys < minKeysPerSegment;
        OngoingStubbing stub = Mockito.when((Object)((UUID)generator.getKey()));
        while (IntStream.of(keysPerSegment).anyMatch(needMoreKeys)) {
            int segment;
            UUID key = UUID.randomUUID();
            int n = segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
            keysPerSegment[n] = keysPerSegment[n] + 1;
            stub = stub.thenReturn((Object)key);
            Mockito.when((Object)partitioner.getSegment((Object)key)).thenReturn((Object)segment);
        }
        Assert.assertThrows(IllegalStateException.class, () -> DefaultKeyAffinityServiceTestCase.lambda$test$2((KeyAffinityService)service, local));
        Assert.assertThrows(IllegalStateException.class, () -> DefaultKeyAffinityServiceTestCase.lambda$test$3((KeyAffinityService)service, remote));
        Assert.assertThrows(IllegalStateException.class, () -> DefaultKeyAffinityServiceTestCase.lambda$test$4((KeyAffinityService)service, standby));
        Assert.assertThrows(IllegalArgumentException.class, () -> DefaultKeyAffinityServiceTestCase.lambda$test$5((KeyAffinityService)service, ignored));
        service.start();
        try {
            int iterations = 50;
            for (int i = 0; i < iterations; ++i) {
                UUID key = (UUID)service.getKeyForAddress(local);
                int segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
                Assert.assertEquals((long)0L, (long)segment);
                key = (UUID)service.getCollocatedKey((Object)key);
                segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
                Assert.assertEquals((long)0L, (long)segment);
                key = (UUID)service.getKeyForAddress(remote);
                segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
                Assert.assertEquals((long)1L, (long)segment);
                key = (UUID)service.getCollocatedKey((Object)key);
                segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
                Assert.assertEquals((long)1L, (long)segment);
            }
            Assert.assertNotNull((Object)service.getKeyForAddress(standby));
            Assert.assertThrows(IllegalArgumentException.class, () -> DefaultKeyAffinityServiceTestCase.lambda$test$6((KeyAffinityService)service, ignored));
        }
        finally {
            service.stop();
        }
    }

    private static int getSegment(UUID key) {
        return Math.abs(key.hashCode()) % 3;
    }

    private static /* synthetic */ void lambda$test$6(KeyAffinityService service, Address ignored) throws Throwable {
        service.getKeyForAddress(ignored);
    }

    private static /* synthetic */ void lambda$test$5(KeyAffinityService service, Address ignored) throws Throwable {
        service.getKeyForAddress(ignored);
    }

    private static /* synthetic */ void lambda$test$4(KeyAffinityService service, Address standby) throws Throwable {
        service.getKeyForAddress(standby);
    }

    private static /* synthetic */ void lambda$test$3(KeyAffinityService service, Address remote) throws Throwable {
        service.getKeyForAddress(remote);
    }

    private static /* synthetic */ void lambda$test$2(KeyAffinityService service, Address local) throws Throwable {
        service.getKeyForAddress(local);
    }
}

