/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.function;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.infinispan.spi.function.ConcurrentSetAddFunction;
import org.wildfly.clustering.infinispan.spi.function.ConcurrentSetRemoveFunction;
import org.wildfly.clustering.infinispan.spi.function.CopyOnWriteSetAddFunction;
import org.wildfly.clustering.infinispan.spi.function.CopyOnWriteSetRemoveFunction;

public class FunctionTestCase {
    @Test
    public void copyOnWriteSet() {
        Set result = (Set)new CopyOnWriteSetAddFunction((Object)"foo").apply(null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("foo"));
        Set result2 = (Set)new CopyOnWriteSetAddFunction((Object)"bar").apply(null, (Object)result);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotSame((Object)result, (Object)result2);
        Assert.assertTrue((boolean)result2.contains("foo"));
        Assert.assertTrue((boolean)result2.contains("bar"));
        Set result3 = (Set)new CopyOnWriteSetRemoveFunction((Object)"foo").apply(null, (Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertNotSame((Object)result2, (Object)result3);
        Assert.assertFalse((boolean)result3.contains("foo"));
        Assert.assertTrue((boolean)result3.contains("bar"));
        Set result4 = (Set)new CopyOnWriteSetRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assert.assertNull((Object)result4);
    }

    @Test
    public void concurrentSet() {
        Set result = (Set)new ConcurrentSetAddFunction((Object)"foo").apply(null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("foo"));
        Set result2 = (Set)new ConcurrentSetAddFunction((Object)"bar").apply(null, (Object)result);
        Assert.assertNotNull((Object)result2);
        Assert.assertSame((Object)result, (Object)result2);
        Assert.assertTrue((boolean)result2.contains("foo"));
        Assert.assertTrue((boolean)result2.contains("bar"));
        Set result3 = (Set)new ConcurrentSetRemoveFunction((Object)"foo").apply(null, (Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertSame((Object)result2, (Object)result3);
        Assert.assertFalse((boolean)result3.contains("foo"));
        Assert.assertTrue((boolean)result3.contains("bar"));
        Set result4 = (Set)new ConcurrentSetRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assert.assertNull((Object)result4);
    }
}

