/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.metadata;

import java.io.IOException;
import java.util.OptionalInt;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class EmbeddedMetadataMarshaller<MD extends EmbeddedMetadata>
implements ProtoStreamMarshaller<EmbeddedMetadata> {
    private Class<MD> targetClass;

    EmbeddedMetadataMarshaller(Class<MD> targetClass) {
        this.targetClass = targetClass;
    }

    public EmbeddedMetadata readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        EmbeddedMetadata.Builder builder = new EmbeddedMetadata.Builder();
        int tag = reader.readTag();
        Long version = null;
        Integer topologyId = null;
        while (tag != 0) {
            int field = WireFormat.getTagFieldNumber((int)tag);
            switch (field) {
                case 1: {
                    version = reader.readSInt64();
                    break;
                }
                case 2: {
                    topologyId = reader.readSInt32();
                    break;
                }
                case 3: {
                    builder.lifespan(reader.readUInt64());
                    break;
                }
                case 4: {
                    builder.maxIdle(reader.readUInt64());
                    break;
                }
                default: {
                    reader.skipField(tag);
                }
            }
            tag = reader.readTag();
        }
        if (version != null) {
            builder.version((EntryVersion)(topologyId != null ? new SimpleClusteredVersion(topologyId.intValue(), version.longValue()) : new NumericVersion(version.longValue())));
        }
        return (EmbeddedMetadata)builder.build();
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, EmbeddedMetadata metadata) throws IOException {
        if (metadata.getClusteredVersion() != null) {
            writer.writeSInt64(1, metadata.getClusteredVersion().getVersion());
            writer.writeSInt32(2, metadata.getClusteredVersion().getTopologyId());
        } else if (metadata.getNumericVersion() != null) {
            writer.writeSInt64(1, metadata.getNumericVersion().getVersion());
        }
        if (metadata.lifespan() != -1L) {
            writer.writeUInt64(3, metadata.lifespan());
        }
        if (metadata.maxIdle() != -1L) {
            writer.writeUInt64(4, metadata.maxIdle());
        }
    }

    public OptionalInt size(ImmutableSerializationContext context, EmbeddedMetadata metadata) {
        int size = 0;
        if (metadata.getClusteredVersion() != null) {
            size += Predictable.signedLongSize((long)metadata.getClusteredVersion().getVersion()) + 1;
            size += Predictable.signedIntSize((int)metadata.getClusteredVersion().getTopologyId()) + 1;
        } else if (metadata.getNumericVersion() != null) {
            size += Predictable.signedLongSize((long)metadata.getNumericVersion().getVersion()) + 1;
        }
        if (metadata.lifespan() != -1L) {
            size += Predictable.signedLongSize((long)metadata.lifespan()) + 1;
        }
        if (metadata.maxIdle() != -1L) {
            size += Predictable.signedLongSize((long)metadata.maxIdle()) + 1;
        }
        return OptionalInt.of(size);
    }

    public Class<? extends EmbeddedMetadata> getJavaClass() {
        return this.targetClass;
    }
}

