/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.ModuleBuilder;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ChannelClusterBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkChannelFactoryBuilder;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.spi.DistributedGroupBuilderProvider;
import org.wildfly.clustering.spi.GroupBuilderProvider;

public class ChannelServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        String stack = ChannelResourceDefinition.Attribute.STACK.resolveModelAttribute((ExpressionResolver)context, model).asString();
        ServiceTarget target = context.getServiceTarget();
        new ChannelClusterBuilder(ChannelResourceDefinition.Capability.JCHANNEL_CLUSTER.getServiceName(address), name).configure(context, model).build(target).install();
        new ChannelBuilder(ChannelResourceDefinition.Capability.JCHANNEL.getServiceName(address), name).statisticsEnabled(ChannelResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).configure(context, model).build(target).install();
        new AliasServiceBuilder(ChannelResourceDefinition.Capability.JCHANNEL_FACTORY.getServiceName(address), JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, stack), JGroupsRequirement.CHANNEL_FACTORY.getType()).build(target).install();
        new ForkChannelFactoryBuilder(ChannelResourceDefinition.Capability.FORK_CHANNEL_FACTORY.getServiceName(address), name).configure(context, model).build(target).install();
        new ModuleBuilder(ChannelResourceDefinition.Capability.JCHANNEL_MODULE.getServiceName(address), (Attribute)ChannelResourceDefinition.Attribute.MODULE).configure(context, model).build(target).install();
        new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding(name), JGroupsRequirement.CHANNEL.getServiceName(context, name), JGroupsRequirement.CHANNEL.getType()).build(target).install();
        new BinderServiceBuilder(JGroupsBindingFactory.createChannelFactoryBinding(name), JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, name), JGroupsRequirement.CHANNEL_FACTORY.getType()).build(target).install();
        for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(DistributedGroupBuilderProvider.class, DistributedGroupBuilderProvider.class.getClassLoader())) {
            for (CapabilityServiceBuilder builder : groupBuilderProvider.getBuilders(requirement -> ChannelResourceDefinition.CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), name)) {
                JGroupsLogger.ROOT_LOGGER.debugf("Installing %s for channel %s", builder.getServiceName(), name);
                builder.configure(context).build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        EnumSet.allOf(ChannelResourceDefinition.Capability.class).forEach(capability -> context.removeService(capability.getServiceName(address)));
        context.removeService(JGroupsBindingFactory.createChannelBinding(name).getBinderServiceName());
        context.removeService(JGroupsBindingFactory.createChannelFactoryBinding(name).getBinderServiceName());
        for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(DistributedGroupBuilderProvider.class, DistributedGroupBuilderProvider.class.getClassLoader())) {
            for (ServiceNameProvider builder : groupBuilderProvider.getBuilders(requirement -> ChannelResourceDefinition.CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), name)) {
                JGroupsLogger.ROOT_LOGGER.debugf("Removing %s for channel %s", builder.getServiceName(), name);
                context.removeService(builder.getServiceName());
            }
        }
    }
}

