/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.transform.LegacyPropertyAddOperationTransformer;
import org.jboss.as.clustering.controller.transform.LegacyPropertyResourceTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;

public class ProtocolResourceDefinition<P extends Protocol>
extends AbstractProtocolResourceDefinition<P, ProtocolConfiguration<P>> {
    static final PathElement WILDCARD_PATH = ProtocolResourceDefinition.pathElement("*");

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"protocol", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        ProtocolResourceDefinition.addTransformations(version, builder);
    }

    static void addTransformations(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        AbstractProtocolResourceDefinition.addTransformations(version, builder);
        if (JGroupsModel.VERSION_4_1_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"add-index"});
        }
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            org.jboss.as.clustering.controller.transform.OperationTransformer addTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    PathAddress stackAddress = address.subAddress(0, address.size() - 1);
                    ModelNode addProtocolOp = operation.clone();
                    addProtocolOp.get("address").set(stackAddress.toModelNode());
                    addProtocolOp.get("operation").set("add-protocol");
                    addProtocolOp = new LegacyPropertyAddOperationTransformer(op -> Operations.getPathAddress((ModelNode)op).append(new PathElement[]{ProtocolResourceDefinition.pathElement(op.get(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).asString())})).transformOperation(addProtocolOp);
                    return addProtocolOp;
                }
            };
            builder.addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)new SimpleOperationTransformer(addTransformer)).inheritResourceAttributeDefinitions();
            org.jboss.as.clustering.controller.transform.OperationTransformer removeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    String protocol = address.getLastElement().getValue();
                    PathAddress stackAddress = address.subAddress(0, address.size() - 1);
                    ModelNode legacyOperation = Util.createOperation((String)"remove-protocol", (PathAddress)stackAddress);
                    legacyOperation.get(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).set(protocol);
                    return legacyOperation;
                }
            };
            builder.addOperationTransformationOverride("remove").setCustomOperationTransformer((OperationTransformer)new SimpleOperationTransformer(removeTransformer));
            builder.setCustomResourceTransformer((ResourceTransformer)new LegacyPropertyResourceTransformer());
        }
    }

    ProtocolResourceDefinition(Consumer<ResourceDescriptor> descriptorConfigurator, ResourceServiceBuilderFactory<ProtocolConfiguration<P>> builderFactory, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        super(new SimpleResourceDefinition.Parameters(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(WILDCARD_PATH)).setOrderedChild(), descriptor -> descriptor.addExtraParameters(DeprecatedAttribute.class), builderFactory, parentBuilderFactory, (parent, registration) -> EnumSet.allOf(DeprecatedAttribute.class).forEach(attribute -> registration.registerReadOnlyAttribute(attribute.getDefinition(), null)));
    }

    ProtocolResourceDefinition(PathElement path, Consumer<ResourceDescriptor> descriptorConfigurator, ResourceServiceBuilderFactory<ProtocolConfiguration<P>> builderFactory, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        super(new SimpleResourceDefinition.Parameters(path, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(path, WILDCARD_PATH)).setOrderedChild(), descriptorConfigurator, builderFactory, parentBuilderFactory, (parent, registration) -> {});
    }

    @Deprecated
    static enum DeprecatedAttribute implements Attribute
    {
        SOCKET_BINDING("socket-binding", ModelType.STRING, JGroupsModel.VERSION_4_1_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, JGroupsModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)AbstractProtocolResourceDefinition.createBuilder(name, type, null).setDeprecated(deprecation.getVersion())).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

