/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JDBCProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketBindingProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;

public enum XMLAttribute {
    UNKNOWN(""),
    CHANNEL(RemoteSiteResourceDefinition.Attribute.CHANNEL),
    CLUSTER(ChannelResourceDefinition.Attribute.CLUSTER),
    DATA_SOURCE(JDBCProtocolResourceDefinition.Attribute.DATA_SOURCE),
    DEFAULT_EXECUTOR(TransportResourceDefinition.ThreadingAttribute.DEFAULT_EXECUTOR),
    DEFAULT("default"),
    DEFAULT_STACK("default-stack"),
    DIAGNOSTICS_SOCKET_BINDING(TransportResourceDefinition.Attribute.DIAGNOSTICS_SOCKET_BINDING),
    KEEPALIVE_TIME(ThreadPoolResourceDefinition.DEFAULT.getKeepAliveTime()),
    KEY_ALIAS(EncryptProtocolResourceDefinition.Attribute.KEY_ALIAS),
    KEY_STORE(EncryptProtocolResourceDefinition.Attribute.KEY_STORE),
    MACHINE(TransportResourceDefinition.Attribute.MACHINE),
    MAX_THREADS(ThreadPoolResourceDefinition.DEFAULT.getMaxThreads()),
    MIN_THREADS(ThreadPoolResourceDefinition.DEFAULT.getMinThreads()),
    MODULE(AbstractProtocolResourceDefinition.Attribute.MODULE),
    NAME("name"),
    OOB_EXECUTOR(TransportResourceDefinition.ThreadingAttribute.OOB_EXECUTOR),
    QUEUE_LENGTH(ThreadPoolResourceDefinition.DEFAULT.getQueueLength()),
    RACK(TransportResourceDefinition.Attribute.RACK),
    SHARED(TransportResourceDefinition.Attribute.SHARED),
    SITE(TransportResourceDefinition.Attribute.SITE),
    SOCKET_BINDING(SocketBindingProtocolResourceDefinition.Attribute.SOCKET_BINDING),
    STACK(RemoteSiteResourceDefinition.DeprecatedAttribute.STACK),
    STATISTICS_ENABLED(ChannelResourceDefinition.Attribute.STATISTICS_ENABLED),
    THREAD_FACTORY(TransportResourceDefinition.ThreadingAttribute.THREAD_FACTORY),
    TIMER_EXECUTOR(TransportResourceDefinition.ThreadingAttribute.TIMER_EXECUTOR),
    TYPE("type");

    private final String name;
    private static final Map<String, XMLAttribute> attributes;

    private XMLAttribute(Attribute attribute) {
        this(((AttributeDefinition)attribute.getDefinition()).getXmlName());
    }

    private XMLAttribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static XMLAttribute forName(String localName) {
        XMLAttribute attribute = attributes.get(localName);
        return attribute != null ? attribute : UNKNOWN;
    }

    static {
        attributes = new HashMap<String, XMLAttribute>();
        for (XMLAttribute attribute : XMLAttribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            attributes.put(name, attribute);
        }
    }
}

