/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.transform.LegacyPropertyAddOperationTransformer;
import org.jboss.as.clustering.controller.transform.LegacyPropertyResourceTransformer;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.GenericProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;

public class ProtocolResourceDefinition<P extends Protocol>
extends AbstractProtocolResourceDefinition<P, ProtocolConfiguration<P>> {
    static final PathElement WILDCARD_PATH = ProtocolResourceDefinition.pathElement("*");
    static final UnaryOperator<OperationStepHandler> LEGACY_OPERATION_TRANSFORMER = handler -> (context, operation) -> {
        PathElement legacyPath;
        PathAddress address = context.getCurrentAddress();
        PathAddress parentAddress = address.getParent();
        Resource parent = context.readResourceFromRoot(parentAddress, false);
        if (parent.hasChild(legacyPath = GenericProtocolResourceDefinition.pathElement(address.getLastElement().getValue()))) {
            PathAddress legacyAddress = parentAddress.append(new PathElement[]{legacyPath});
            Operations.setPathAddress((ModelNode)operation, (PathAddress)legacyAddress);
            String operationName = Operations.getName((ModelNode)operation);
            context.addStep(operation, context.getRootResourceRegistration().getOperationHandler(legacyAddress, operationName), OperationContext.Stage.MODEL);
        } else {
            handler.execute(context, operation);
        }
    };

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"protocol", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        ProtocolResourceDefinition.addTransformations(version, builder);
    }

    static void addTransformations(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        AbstractProtocolResourceDefinition.addTransformations(version, builder);
        if (JGroupsModel.VERSION_4_1_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"add-index"});
        }
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            OperationTransformer addTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    PathAddress stackAddress = address.subAddress(0, address.size() - 1);
                    ModelNode addProtocolOp = operation.clone();
                    addProtocolOp.get("address").set(stackAddress.toModelNode());
                    addProtocolOp.get("operation").set("add-protocol");
                    addProtocolOp = new LegacyPropertyAddOperationTransformer(op -> Operations.getPathAddress((ModelNode)op).append(new PathElement[]{ProtocolResourceDefinition.pathElement(op.get(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).asString())})).transformOperation(addProtocolOp);
                    return addProtocolOp;
                }
            };
            builder.addOperationTransformationOverride("add").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(addTransformer)).inheritResourceAttributeDefinitions();
            OperationTransformer removeTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    String protocol = address.getLastElement().getValue();
                    PathAddress stackAddress = address.subAddress(0, address.size() - 1);
                    ModelNode legacyOperation = Util.createOperation((String)"remove-protocol", (PathAddress)stackAddress);
                    legacyOperation.get(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).set(protocol);
                    return legacyOperation;
                }
            };
            builder.addOperationTransformationOverride("remove").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(removeTransformer));
            builder.setCustomResourceTransformer((ResourceTransformer)new LegacyPropertyResourceTransformer());
        }
    }

    ProtocolResourceDefinition(PathElement path, Consumer<ResourceDescriptor> descriptorConfigurator, ResourceServiceBuilderFactory<ProtocolConfiguration<P>> builderFactory, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this(path, descriptorConfigurator, builderFactory, parentBuilderFactory, (ManagementResourceRegistration parent, ManagementResourceRegistration registration) -> {});
    }

    ProtocolResourceDefinition(PathElement path, Consumer<ResourceDescriptor> descriptorConfigurator, ResourceServiceBuilderFactory<ProtocolConfiguration<P>> builderFactory, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory, BiConsumer<ManagementResourceRegistration, ManagementResourceRegistration> registrationConfigurator) {
        super(new SimpleResourceDefinition.Parameters(path, path.isWildcard() ? JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path}) : JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path, WILDCARD_PATH})).setOrderedChild(), descriptorConfigurator.andThen(descriptor -> descriptor.addCapabilities(Capability.class)), builderFactory, parentBuilderFactory, registrationConfigurator);
    }

    static class LegacyAddOperationTransformation
    implements UnaryOperator<OperationStepHandler> {
        private final Predicate<ModelNode> legacy;

        <E extends Enum<E>> LegacyAddOperationTransformation(Class<E> attributeClass) {
            this(EnumSet.allOf(attributeClass));
        }

        LegacyAddOperationTransformation(Set<? extends Attribute> attributes) {
            this((ModelNode operation) -> attributes.stream().noneMatch(attribute -> operation.hasDefined(attribute.getName())));
        }

        LegacyAddOperationTransformation(String ... legacyProperties) {
            this((ModelNode operation) -> operation.hasDefined(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getName()) && Stream.of(legacyProperties).anyMatch(legacyProperty -> operation.get(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getName()).hasDefined(legacyProperty)));
        }

        LegacyAddOperationTransformation(Predicate<ModelNode> legacy) {
            this.legacy = legacy;
        }

        @Override
        public OperationStepHandler apply(OperationStepHandler handler) {
            return (context, operation) -> {
                if (this.legacy.test(operation)) {
                    PathElement path = context.getCurrentAddress().getLastElement();
                    Operations.setPathAddress((ModelNode)operation, (PathAddress)context.getCurrentAddress().getParent().append(new PathElement[]{GenericProtocolResourceDefinition.pathElement(path.getValue())}));
                    OperationStepHandler genericHandler = context.getResourceRegistration().getParent().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{WILDCARD_PATH}), "add");
                    context.addStep(operation, genericHandler, OperationContext.Stage.MODEL, true);
                } else {
                    handler.execute(context, operation);
                }
            };
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        PROTOCOL("org.wildfly.clustering.jgroups.protocol");

        private final RuntimeCapability<Void> definition;

        private Capability(String name) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).setAllowMultipleRegistrations(true).build();
        }

        public RuntimeCapability<?> getDefinition() {
            return this.definition;
        }

        public RuntimeCapability<?> resolve(PathAddress address) {
            return this.definition.fromBaseCapability(new String[]{address.getParent().getLastElement().getValue(), address.getLastElement().getValue()});
        }
    }
}

