/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.SingletonProtocolServiceNameProvider;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.jgroups.JChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class RelayConfigurationBuilder
extends AbstractProtocolConfigurationBuilder<RELAY2, RelayConfiguration>
implements RelayConfiguration {
    private final ServiceNameProvider provider;
    private volatile List<ValueDependency<RemoteSiteConfiguration>> sites;
    private volatile String siteName = null;

    public RelayConfigurationBuilder(PathAddress address) {
        super(address.getLastElement().getValue());
        this.provider = new SingletonProtocolServiceNameProvider(address);
    }

    public ServiceName getServiceName() {
        return this.provider.getServiceName();
    }

    @Override
    public ServiceBuilder<RelayConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        this.sites.forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public Builder<RelayConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.siteName = RelayResourceDefinition.Attribute.SITE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        PathAddress address = context.getCurrentAddress();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        this.sites = resource.getChildren(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).stream().map(entry -> new InjectedValueDependency((ServiceNameProvider)new RemoteSiteServiceNameProvider(address, entry.getPathElement()), RemoteSiteConfiguration.class)).collect(Collectors.toList());
        return super.configure(context, model);
    }

    public RelayConfiguration getValue() {
        return this;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public List<RemoteSiteConfiguration> getRemoteSites() {
        return this.sites.stream().map(Value::getValue).collect(Collectors.toList());
    }

    @Override
    public void accept(RELAY2 protocol) {
        String localSite = this.siteName;
        List<RemoteSiteConfiguration> remoteSites = this.getRemoteSites();
        ArrayList<String> sites = new ArrayList<String>(remoteSites.size() + 1);
        sites.add(localSite);
        HashMap<String, 1> bridges = new HashMap<String, 1>();
        for (final RemoteSiteConfiguration remoteSite : remoteSites) {
            final String siteName = remoteSite.getName();
            sites.add(siteName);
            String clusterName = remoteSite.getClusterName();
            RelayConfig.BridgeConfig bridge = new RelayConfig.BridgeConfig(clusterName){

                public JChannel createChannel() throws Exception {
                    JChannel channel = remoteSite.getChannelFactory().createChannel(siteName);
                    channel.getProtocolStack().removeProtocol(FORK.class);
                    return channel;
                }
            };
            bridges.put(clusterName, bridge);
        }
        protocol.site(localSite);
        for (String site : sites) {
            RelayConfig.SiteConfig siteConfig = new RelayConfig.SiteConfig(site);
            protocol.addSite(site, siteConfig);
            if (!site.equals(localSite)) continue;
            for (RelayConfig.BridgeConfig bridge : bridges.values()) {
                siteConfig.addBridge(bridge);
            }
        }
    }
}

