package org.jboss.as.clustering.jgroups.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import java.net.UnknownHostException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URL;
import org.jboss.logging.BasicLogger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-11-14T18:08:43-0800")
public class JGroupsLogger_$logger extends DelegatingBasicLogger implements JGroupsLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JGroupsLogger_$logger.class.getName();
    public JGroupsLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem(final String version) {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str(), version);
    }
    private static final String activatingSubsystem = "WFLYCLJG0001: Activating JGroups subsystem. JGroups version %s";
    protected String activatingSubsystem$str() {
        return activatingSubsystem;
    }
    private static final String parserFailure = "WFLYCLJG0007: Failed to parse %s";
    protected String parserFailure$str() {
        return parserFailure;
    }
    @Override
    public final String parserFailure(final URL url) {
        return String.format(getLoggingLocale(), parserFailure$str(), url);
    }
    private static final String notFound = "WFLYCLJG0008: Failed to locate %s";
    protected String notFound$str() {
        return notFound;
    }
    @Override
    public final String notFound(final String resource) {
        return String.format(getLoggingLocale(), notFound$str(), resource);
    }
    private static final String transportNotDefined = "WFLYCLJG0010: Transport for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.";
    protected String transportNotDefined$str() {
        return transportNotDefined;
    }
    @Override
    public final OperationFailedException transportNotDefined(final String stackName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), transportNotDefined$str(), stackName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMetric = "WFLYCLJG0015: Unknown metric %s";
    protected String unknownMetric$str() {
        return unknownMetric;
    }
    @Override
    public final String unknownMetric(final String metricName) {
        return String.format(getLoggingLocale(), unknownMetric$str(), metricName);
    }
    private static final String unableToLoadProtocolClass = "WFLYCLJG0016: Unable to load protocol class %s";
    protected String unableToLoadProtocolClass$str() {
        return unableToLoadProtocolClass;
    }
    @Override
    public final OperationFailedException unableToLoadProtocolClass(final String protocolName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToLoadProtocolClass$str(), protocolName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String privilegedAccessExceptionForAttribute = "WFLYCLJG0017: Privileged access exception on attribute/method %s";
    protected String privilegedAccessExceptionForAttribute$str() {
        return privilegedAccessExceptionForAttribute;
    }
    @Override
    public final String privilegedAccessExceptionForAttribute(final String attrName) {
        return String.format(getLoggingLocale(), privilegedAccessExceptionForAttribute$str(), attrName);
    }
    private static final String threadsAttributesUsedInRuntime = "WFLYCLJG0021: Attributes referencing threads subsystem can only be used to support older slaves in the domain.";
    protected String threadsAttributesUsedInRuntime$str() {
        return threadsAttributesUsedInRuntime;
    }
    @Override
    public final String threadsAttributesUsedInRuntime() {
        return String.format(getLoggingLocale(), threadsAttributesUsedInRuntime$str());
    }
    private static final String keyEntryNotFound = "WFLYCLJG0022: %s entry not found in configured key store";
    protected String keyEntryNotFound$str() {
        return keyEntryNotFound;
    }
    @Override
    public final IllegalArgumentException keyEntryNotFound(final String alias) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), keyEntryNotFound$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedKeyStoreEntryType = "WFLYCLJG0023: %s key store entry is not of the expected type: %s";
    protected String unexpectedKeyStoreEntryType$str() {
        return unexpectedKeyStoreEntryType;
    }
    @Override
    public final IllegalArgumentException unexpectedKeyStoreEntryType(final String alias, final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedKeyStoreEntryType$str(), alias, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String secretKeyStoreEntryExpected = "WFLYCLJG0024: %s key store entry does not contain a secret key";
    protected String secretKeyStoreEntryExpected$str() {
        return secretKeyStoreEntryExpected;
    }
    @Override
    public final IllegalArgumentException secretKeyStoreEntryExpected(final String alias) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), secretKeyStoreEntryExpected$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedCredentialSource = "WFLYCLJG0025: Configured credential source does not reference a clear-text password credential";
    protected String unexpectedCredentialSource$str() {
        return unexpectedCredentialSource;
    }
    @Override
    public final IllegalArgumentException unexpectedCredentialSource() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedCredentialSource$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToResolveSocketBinding = "WFLYCLJG0028: Could not resolve destination address for outbound socket binding named '%s'";
    protected String failedToResolveSocketBinding$str() {
        return failedToResolveSocketBinding;
    }
    @Override
    public final IllegalArgumentException failedToResolveSocketBinding(final UnknownHostException cause, final OutboundSocketBinding binding) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failedToResolveSocketBinding$str(), binding), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void legacyProtocol(final String legacyProtocol, final String targetProtocol) {
        super.log.logf(FQCN, WARN, null, legacyProtocol$str(), legacyProtocol, targetProtocol);
    }
    private static final String legacyProtocol = "WFLYCLJG0030: Protocol %s is obsolete and will be auto-updated to %s";
    protected String legacyProtocol$str() {
        return legacyProtocol;
    }
}
