/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.PropertiesTestUtil;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketBindingProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.dmr.ModelNode;
import org.jgroups.conf.ClassConfigurator;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.service.UnaryRequirement;

public class JGroupsTransformersTestCase
extends OperationTestCaseBase {
    private static String formatEAP6SubsystemArtifact(ModelTestControllerVersion version) {
        return JGroupsTransformersTestCase.formatArtifact("org.jboss.as:jboss-as-clustering-jgroups:%s", version);
    }

    private static String formatEAP7SubsystemArtifact(ModelTestControllerVersion version) {
        return JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-jgroups-extension:%s", version);
    }

    private static String formatArtifact(String pattern, ModelTestControllerVersion version) {
        return String.format(pattern, version.getMavenGavVersion());
    }

    private static JGroupsModel getModelVersion(ModelTestControllerVersion controllerVersion) {
        switch (controllerVersion) {
            case EAP_6_4_0: 
            case EAP_6_4_7: {
                return JGroupsModel.VERSION_1_3_0;
            }
            case EAP_7_0_0: {
                return JGroupsModel.VERSION_4_0_0;
            }
            case EAP_7_1_0: {
                return JGroupsModel.VERSION_5_0_0;
            }
            case EAP_7_2_0: {
                return JGroupsModel.VERSION_6_0_0;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String[] getDependencies(ModelTestControllerVersion version) {
        switch (version) {
            case EAP_6_4_0: 
            case EAP_6_4_7: {
                return new String[]{JGroupsTransformersTestCase.formatEAP6SubsystemArtifact(version)};
            }
            case EAP_7_0_0: 
            case EAP_7_1_0: 
            case EAP_7_2_0: {
                return new String[]{JGroupsTransformersTestCase.formatEAP7SubsystemArtifact(version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-common:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-jgroups-spi:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-service:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-spi:%s", version)};
            }
        }
        throw new IllegalArgumentException();
    }

    private static AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require((UnaryRequirement)CommonUnaryRequirement.SOCKET_BINDING, new String[]{"jgroups-tcp", "jgroups-udp", "jgroups-udp-fd", "some-binding", "jgroups-diagnostics", "jgroups-mping", "jgroups-tcp-fd", "jgroups-state-xfr"});
    }

    @Test
    public void testTransformerEAP640() throws Exception {
        this.testTransformation(ModelTestControllerVersion.EAP_6_4_0);
    }

    @Test
    public void testTransformerEAP700() throws Exception {
        this.testTransformation(ModelTestControllerVersion.EAP_7_0_0);
    }

    @Test
    public void testTransformerEAP710() throws Exception {
        this.testTransformation(ModelTestControllerVersion.EAP_7_1_0);
    }

    @Test
    public void testTransformerEAP720() throws Exception {
        this.testTransformation(ModelTestControllerVersion.EAP_7_2_0);
    }

    private void testTransformation(ModelTestControllerVersion controller) throws Exception {
        ModelVersion version = JGroupsTransformersTestCase.getModelVersion(controller).getVersion();
        String[] dependencies = JGroupsTransformersTestCase.getDependencies(controller);
        String subsystemXmlResource = String.format("subsystem-jgroups-transform-%d_%d_%d.xml", version.getMajor(), version.getMinor(), version.getMicro());
        KernelServicesBuilder builder = this.createKernelServicesBuilder(JGroupsTransformersTestCase.createAdditionalInitialization()).setSubsystemXmlResource(subsystemXmlResource);
        builder.createLegacyKernelServicesBuilder(JGroupsTransformersTestCase.createAdditionalInitialization(), controller, version).addMavenResourceURL(dependencies).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addSingleChildFirstClass(new Class[]{ClassConfigurator.class}).skipReverseControllerCheck().dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        this.checkSubsystemModelTransformation(services, version, null, false);
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            JGroupsTransformersTestCase.propertiesMapOperationsTest(services, version);
            this.testNonMapTransformersWork(services, version);
        }
    }

    private static void propertiesMapOperationsTest(KernelServices services, ModelVersion version) throws Exception {
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportUndefinePropertiesOperation("maximal", "TCP"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[0]);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "true"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "false"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "true", "loopback", "false"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "true"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "true", "loopback", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"loopback", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "false"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "false", "loopback", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportClearPropertiesOperation("maximal", "TCP"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[0]);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolUndefinePropertiesOperation("maximal", "MPING"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[0]);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "true"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "true", "receive_on_all_interfaces", "false"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[0]);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"receive_on_all_interfaces", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"receive_on_all_interfaces", "false"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolClearPropertiesOperation("maximal", "MPING"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[0]);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        composite.get("steps").add(JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "false"));
        composite.get("steps").add(JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        composite.get("steps").add(JGroupsTransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "true"));
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)composite);
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        composite.get("steps").setEmptyList();
        composite.get("steps").add(JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "true"));
        composite.get("steps").add(JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        composite.get("steps").add(JGroupsTransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "false"));
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)composite);
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "true", "receive_on_all_interfaces", "false"});
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "false"});
        composite.get("steps").setEmptyList();
        composite.get("steps").add(JGroupsTransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        composite.get("steps").add(JGroupsTransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        composite.get("steps").add(JGroupsTransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "false"));
        composite.get("steps").add(JGroupsTransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)composite);
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[0]);
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"loopback", "false"});
        composite.get("steps").setEmptyList();
        composite.get("steps").add(JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "false"));
        composite.get("steps").add(JGroupsTransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        composite.get("steps").add(JGroupsTransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)composite);
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)JGroupsTransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "false", "receive_on_all_interfaces", "true"});
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)JGroupsTransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[0]);
    }

    private void testNonMapTransformersWork(KernelServices services, ModelVersion version) throws Exception {
        PathAddress stackAddr = PathAddress.pathAddress((String)"subsystem", (String)this.getMainSubsystemName()).append("stack", "test");
        ModelNode addStack = Util.createAddOperation((PathAddress)stackAddr);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)addStack);
        PathAddress transportAddr = stackAddr.append("transport", "tcp");
        ModelNode addTransport = Util.createAddOperation((PathAddress)transportAddr);
        addTransport.get(SocketBindingProtocolResourceDefinition.Attribute.SOCKET_BINDING.getName()).set("some-binding");
        addTransport.get("module").set("do.reject");
        OperationTransformer.TransformedOperation op = services.executeInMainAndGetTheTransformedOperation(addTransport, version);
        Assert.assertTrue((boolean)op.rejectOperation(JGroupsTransformersTestCase.success()));
        PathAddress protocolAddr = stackAddr.append("protocol", "PING");
        ModelNode addProtocol = Util.createAddOperation((PathAddress)protocolAddr);
        addProtocol.get("module").set("do.reject");
        op = services.executeInMainAndGetTheTransformedOperation(addProtocol, version);
        Assert.assertTrue((boolean)op.rejectOperation(JGroupsTransformersTestCase.success()));
        op = services.executeInMainAndGetTheTransformedOperation(Util.getWriteAttributeOperation((PathAddress)transportAddr, (String)"module", (String)"reject.this"), version);
        Assert.assertTrue((boolean)op.rejectOperation(JGroupsTransformersTestCase.success()));
        op = services.executeInMainAndGetTheTransformedOperation(Util.getWriteAttributeOperation((PathAddress)protocolAddr, (String)"module", (String)"reject.this"), version);
        Assert.assertTrue((boolean)op.rejectOperation(JGroupsTransformersTestCase.success()));
    }

    @Test
    public void testRejectionsEAP640() throws Exception {
        this.testRejections(ModelTestControllerVersion.EAP_6_4_0);
    }

    @Test
    public void testRejectionsEAP700() throws Exception {
        this.testRejections(ModelTestControllerVersion.EAP_7_0_0);
    }

    @Test
    public void testRejectionsEAP710() throws Exception {
        this.testRejections(ModelTestControllerVersion.EAP_7_1_0);
    }

    @Test
    public void testRejectionsEAP720() throws Exception {
        this.testRejections(ModelTestControllerVersion.EAP_7_2_0);
    }

    private void testRejections(ModelTestControllerVersion controller) throws Exception {
        ModelVersion version = JGroupsTransformersTestCase.getModelVersion(controller).getVersion();
        String[] dependencies = JGroupsTransformersTestCase.getDependencies(controller);
        KernelServicesBuilder builder = this.createKernelServicesBuilder(JGroupsTransformersTestCase.createAdditionalInitialization());
        builder.createLegacyKernelServicesBuilder(JGroupsTransformersTestCase.createAdditionalInitialization(), controller, version).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addMavenResourceURL(dependencies).addSingleChildFirstClass(new Class[]{ClassConfigurator.class}).dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List operations = builder.parseXmlResource("subsystem-jgroups-transform-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)version, (List)operations, (FailedOperationTransformationConfig)JGroupsTransformersTestCase.createFailedOperationTransformationConfig(version));
    }

    private static FailedOperationTransformationConfig createFailedOperationTransformationConfig(ModelVersion version) {
        FailedOperationTransformationConfig config = new FailedOperationTransformationConfig();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{ThreadPoolResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        if (JGroupsModel.VERSION_2_0_0.requiresTransformation(version)) {
            PathAddress stackAddress = subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH});
            PathAddress relayAddress = stackAddress.append(new PathElement[]{RelayResourceDefinition.PATH});
            config.addFailedAttribute(relayAddress, FailedOperationTransformationConfig.REJECTED_RESOURCE);
            config.addFailedAttribute(relayAddress.append(new PathElement[]{RemoteSiteResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        return config;
    }

    private static ModelNode success() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("success");
        result.get("result");
        return result;
    }
}

