/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.MulticastProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.UnaryRequirement;

public class OperationTestCaseBase
extends AbstractSubsystemTest {
    static final String SUBSYSTEM_XML_FILE = String.format("subsystem-jgroups-%d_%d.xml", JGroupsSchema.CURRENT.major(), JGroupsSchema.CURRENT.minor());

    public OperationTestCaseBase() {
        super("jgroups", (Extension)new JGroupsExtension());
    }

    protected static ModelNode getSubsystemAddOperation(String defaultStack) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress());
    }

    protected static ModelNode getSubsystemReadOperation(Attribute attribute) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress(), (Attribute)attribute);
    }

    protected static ModelNode getSubsystemWriteOperation(Attribute attribute, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress(), (Attribute)attribute, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getSubsystemRemoveOperation() {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress());
    }

    protected static ModelNode getProtocolStackAddOperation(String stackName) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolStackAddress(stackName));
    }

    protected static ModelNode getProtocolStackAddOperationWithParameters(String stackName) {
        ModelNode[] operations = new ModelNode[]{OperationTestCaseBase.getProtocolStackAddOperation(stackName), OperationTestCaseBase.getTransportAddOperation(stackName, "UDP"), OperationTestCaseBase.getProtocolAddOperation(stackName, "PING"), OperationTestCaseBase.getProtocolAddOperation(stackName, "pbcast.FLUSH")};
        return Operations.createCompositeOperation((ModelNode[])operations);
    }

    protected static ModelNode getProtocolStackRemoveOperation(String stackName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolStackAddress(stackName));
    }

    protected static ModelNode getTransportAddOperation(String stackName, String protocol) {
        ModelNode operation = Util.createAddOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, protocol));
        operation.get(MulticastProtocolResourceDefinition.Attribute.SOCKET_BINDING.getName()).set("some-binding");
        return operation;
    }

    protected static ModelNode getLegacyTransportAddOperation(String stackName, String protocol) {
        ModelNode op = Util.createAddOperation((PathAddress)OperationTestCaseBase.getLegacyTransportAddress(stackName));
        op.get(AbstractProtocolResourceDefinition.DeprecatedAttribute.TYPE.getName()).set(protocol);
        op.get(MulticastProtocolResourceDefinition.Attribute.SOCKET_BINDING.getName()).set("some-binding");
        return op;
    }

    protected static ModelNode getTransportAddOperationWithProperties(String stackName, String type) {
        ModelNode[] operations = new ModelNode[]{OperationTestCaseBase.getTransportAddOperation(stackName, type), OperationTestCaseBase.getProtocolPropertyAddOperation(stackName, type, "A", "a"), OperationTestCaseBase.getProtocolPropertyAddOperation(stackName, type, "B", "b")};
        return Operations.createCompositeOperation((ModelNode[])operations);
    }

    protected static ModelNode getTransportRemoveOperation(String stackName, String type) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type));
    }

    protected static ModelNode getLegacyTransportRemoveOperation(String stackName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getLegacyTransportAddress(stackName));
    }

    protected static ModelNode getTransportReadOperation(String stackName, String type, Attribute attribute) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (Attribute)attribute);
    }

    protected static ModelNode getTransportWriteOperation(String stackName, String type, Attribute attribute, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (Attribute)attribute, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getTransportPropertyAddOperation(String stackName, String type, String propertyName, String propertyValue) {
        ModelNode operation = Util.createAddOperation((PathAddress)OperationTestCaseBase.getTransportPropertyAddress(stackName, type, propertyName));
        operation.get(PropertyResourceDefinition.VALUE.getName()).set(propertyValue);
        return operation;
    }

    protected static ModelNode getTransportPropertyRemoveOperation(String stackName, String type, String propertyName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getTransportPropertyAddress(stackName, type, propertyName));
    }

    protected static ModelNode getTransportPropertyReadOperation(String stackName, String type, String propertyName) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getTransportPropertyAddress(stackName, type, propertyName), (Attribute)new SimpleAttribute((AttributeDefinition)PropertyResourceDefinition.VALUE));
    }

    protected static ModelNode getTransportPropertyWriteOperation(String stackName, String type, String propertyName, String propertyValue) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getTransportPropertyAddress(stackName, type, propertyName), (Attribute)new SimpleAttribute((AttributeDefinition)PropertyResourceDefinition.VALUE), (ModelNode)new ModelNode(propertyValue));
    }

    protected static ModelNode getTransportGetPropertyOperation(String stackName, String type, String propertyName) {
        return Operations.createMapGetOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES, (String)propertyName);
    }

    protected static ModelNode getTransportPutPropertyOperation(String stackName, String type, String propertyName, String propertyValue) {
        return Operations.createMapPutOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES, (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getTransportRemovePropertyOperation(String stackName, String type, String propertyName) {
        return Operations.createMapRemoveOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES, (String)propertyName);
    }

    protected static ModelNode getTransportClearPropertiesOperation(String stackName, String type) {
        return Operations.createMapClearOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES);
    }

    protected static ModelNode getTransportUndefinePropertiesOperation(String stackName, String type) {
        return Operations.createUndefineAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES);
    }

    protected static ModelNode getTransportSetPropertiesOperation(String stackName, String type, ModelNode values) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES, (ModelNode)values);
    }

    protected static ModelNode getLegacyThreadPoolAddOperation(String stackName, String threadPoolName) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getLegacyTransportAddress(stackName).append("thread-pool", threadPoolName));
    }

    protected static ModelNode getProtocolAddOperation(String stackName, String type) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, type));
    }

    protected static ModelNode getProtocolAddOperationWithProperties(String stackName, String type) {
        ModelNode[] operations = new ModelNode[]{OperationTestCaseBase.getProtocolAddOperation(stackName, type), OperationTestCaseBase.getProtocolPropertyAddOperation(stackName, type, "A", "a"), OperationTestCaseBase.getProtocolPropertyAddOperation(stackName, type, "B", "b")};
        return Operations.createCompositeOperation((ModelNode[])operations);
    }

    protected static ModelNode getProtocolReadOperation(String stackName, String protocolName, Attribute attribute) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (Attribute)attribute);
    }

    protected static ModelNode getProtocolWriteOperation(String stackName, String protocolName, Attribute attribute, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (Attribute)attribute, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getProtocolPropertyAddOperation(String stackName, String protocolName, String propertyName, String propertyValue) {
        ModelNode operation = Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolPropertyAddress(stackName, protocolName, propertyName));
        operation.get(PropertyResourceDefinition.VALUE.getName()).set(propertyValue);
        return operation;
    }

    protected static ModelNode getProtocolPropertyRemoveOperation(String stackName, String protocolName, String propertyName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolPropertyAddress(stackName, protocolName, propertyName));
    }

    protected static ModelNode getProtocolPropertyReadOperation(String stackName, String protocolName, String propertyName) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolPropertyAddress(stackName, protocolName, propertyName), (Attribute)new SimpleAttribute((AttributeDefinition)PropertyResourceDefinition.VALUE));
    }

    protected static ModelNode getProtocolPropertyWriteOperation(String stackName, String protocolName, String propertyName, String propertyValue) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolPropertyAddress(stackName, protocolName, propertyName), (Attribute)new SimpleAttribute((AttributeDefinition)PropertyResourceDefinition.VALUE), (ModelNode)new ModelNode(propertyValue));
    }

    protected static ModelNode getProtocolGetPropertyOperation(String stackName, String protocolName, String propertyName) {
        return Operations.createMapGetOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES, (String)propertyName);
    }

    protected static ModelNode getProtocolPutPropertyOperation(String stackName, String protocolName, String propertyName, String propertyValue) {
        return Operations.createMapPutOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES, (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getProtocolRemovePropertyOperation(String stackName, String protocolName, String propertyName) {
        return Operations.createMapRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES, (String)propertyName);
    }

    protected static ModelNode getProtocolClearPropertiesOperation(String stackName, String protocolName) {
        return Operations.createMapClearOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES);
    }

    protected static ModelNode getProtocolUndefinePropertiesOperation(String stackName, String protocolName) {
        return Operations.createUndefineAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES);
    }

    protected static ModelNode getProtocolSetPropertiesOperation(String stackName, String protocolName, ModelNode values) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (Attribute)AbstractProtocolResourceDefinition.Attribute.PROPERTIES, (ModelNode)values);
    }

    protected static ModelNode getProtocolRemoveOperation(String stackName, String type) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, type));
    }

    protected static PathAddress getSubsystemAddress() {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
    }

    protected static PathAddress getProtocolStackAddress(String stackName) {
        return OperationTestCaseBase.getSubsystemAddress().append(new PathElement[]{StackResourceDefinition.pathElement((String)stackName)});
    }

    protected static PathAddress getTransportAddress(String stackName, String type) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{TransportResourceDefinition.pathElement((String)type)});
    }

    protected static PathAddress getLegacyTransportAddress(String stackName) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{TransportResourceDefinition.LEGACY_PATH});
    }

    protected static PathAddress getTransportPropertyAddress(String stackName, String type, String propertyName) {
        return OperationTestCaseBase.getTransportAddress(stackName, type).append(new PathElement[]{PropertyResourceDefinition.pathElement((String)propertyName)});
    }

    protected static PathAddress getProtocolAddress(String stackName, String type) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)type)});
    }

    protected static PathAddress getProtocolPropertyAddress(String stackName, String type, String propertyName) {
        return OperationTestCaseBase.getProtocolAddress(stackName, type).append(new PathElement[]{PropertyResourceDefinition.pathElement((String)propertyName)});
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource(SUBSYSTEM_XML_FILE);
    }

    protected KernelServices buildKernelServices() throws Exception {
        return this.createKernelServicesBuilder((AdditionalInitialization)new org.jboss.as.clustering.subsystem.AdditionalInitialization().require((UnaryRequirement)CommonUnaryRequirement.SOCKET_BINDING, new String[]{"some-binding", "jgroups-diagnostics", "jgroups-mping", "jgroups-tcp-fd", "new-socket-binding"})).setSubsystemXml(this.getSubsystemXml()).build();
    }
}

