/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collections;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.network.ManagedServerSocketFactory;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jgroups.util.SocketFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ManagedSocketFactoryTest {
    private SocketBindingManager manager = (SocketBindingManager)Mockito.mock(SocketBindingManager.class);
    private SocketFactory subject = new ManagedSocketFactory(this.manager, Collections.singletonMap("known-service", new SocketBinding("binding", 0, false, null, 0, null, this.manager, Collections.emptyList())));

    @After
    public void destroy() {
        Mockito.reset((Object[])new SocketBindingManager[]{this.manager});
    }

    @Test
    public void createSocket() throws IOException {
        this.createSocket("known-service", "binding");
        this.createSocket("unknown-service", "unknown-service");
    }

    private void createSocket(String serviceName, String bindingName) throws IOException {
        org.jboss.as.network.ManagedSocketFactory factory = (org.jboss.as.network.ManagedSocketFactory)Mockito.mock(org.jboss.as.network.ManagedSocketFactory.class);
        Socket socket1 = (Socket)Mockito.mock(Socket.class);
        Socket socket2 = (Socket)Mockito.mock(Socket.class);
        Socket socket3 = (Socket)Mockito.mock(Socket.class);
        Socket socket4 = (Socket)Mockito.mock(Socket.class);
        Socket socket5 = (Socket)Mockito.mock(Socket.class);
        InetAddress localhost = InetAddress.getLocalHost();
        Mockito.when((Object)this.manager.getSocketFactory()).thenReturn((Object)factory);
        Mockito.when((Object)factory.createSocket(bindingName)).thenReturn((Object)socket1);
        Mockito.when((Object)factory.createSocket(bindingName, localhost, 1)).thenReturn((Object)socket2);
        Mockito.when((Object)factory.createSocket(bindingName, "host", 1)).thenReturn((Object)socket3);
        Mockito.when((Object)factory.createSocket(bindingName, localhost, 1, localhost, 2)).thenReturn((Object)socket4);
        Mockito.when((Object)factory.createSocket(bindingName, "host", 1, localhost, 2)).thenReturn((Object)socket5);
        Socket result1 = this.subject.createSocket(serviceName);
        Socket result2 = this.subject.createSocket(serviceName, localhost, 1);
        Socket result3 = this.subject.createSocket(serviceName, "host", 1);
        Socket result4 = this.subject.createSocket(serviceName, localhost, 1, localhost, 2);
        Socket result5 = this.subject.createSocket(serviceName, "host", 1, localhost, 2);
        Assert.assertSame((Object)socket1, (Object)result1);
        Assert.assertSame((Object)socket2, (Object)result2);
        Assert.assertSame((Object)socket3, (Object)result3);
        Assert.assertSame((Object)socket4, (Object)result4);
        Assert.assertSame((Object)socket5, (Object)result5);
    }

    @Test
    public void createServerSocket() throws IOException {
        this.createServerSocket("known-service", "binding");
        this.createServerSocket("unknown-service", "unknown-service");
    }

    private void createServerSocket(String serviceName, String bindingName) throws IOException {
        ManagedServerSocketFactory factory = (ManagedServerSocketFactory)Mockito.mock(ManagedServerSocketFactory.class);
        ServerSocket socket1 = (ServerSocket)Mockito.mock(ServerSocket.class);
        ServerSocket socket2 = (ServerSocket)Mockito.mock(ServerSocket.class);
        ServerSocket socket3 = (ServerSocket)Mockito.mock(ServerSocket.class);
        ServerSocket socket4 = (ServerSocket)Mockito.mock(ServerSocket.class);
        InetAddress localhost = InetAddress.getLocalHost();
        Mockito.when((Object)this.manager.getServerSocketFactory()).thenReturn((Object)factory);
        Mockito.when((Object)factory.createServerSocket(bindingName)).thenReturn((Object)socket1);
        Mockito.when((Object)factory.createServerSocket(bindingName, 1)).thenReturn((Object)socket2);
        Mockito.when((Object)factory.createServerSocket(bindingName, 1, 0)).thenReturn((Object)socket3);
        Mockito.when((Object)factory.createServerSocket(bindingName, 1, 0, localhost)).thenReturn((Object)socket4);
        ServerSocket result1 = this.subject.createServerSocket(serviceName);
        ServerSocket result2 = this.subject.createServerSocket(serviceName, 1);
        ServerSocket result3 = this.subject.createServerSocket(serviceName, 1, 0);
        ServerSocket result4 = this.subject.createServerSocket(serviceName, 1, 0, localhost);
        Assert.assertSame((Object)socket1, (Object)result1);
        Assert.assertSame((Object)socket2, (Object)result2);
        Assert.assertSame((Object)socket3, (Object)result3);
        Assert.assertSame((Object)socket4, (Object)result4);
    }

    @Test
    public void createDatagramSocket() throws IOException {
        this.createDatagramSocket("known-service", "binding");
        this.createDatagramSocket("unknown-service", "unknown-service");
    }

    private void createDatagramSocket(String serviceName, String bindingName) throws IOException {
        DatagramSocket socket1 = (DatagramSocket)Mockito.mock(DatagramSocket.class);
        DatagramSocket socket2 = (DatagramSocket)Mockito.mock(DatagramSocket.class);
        DatagramSocket socket3 = (DatagramSocket)Mockito.mock(DatagramSocket.class);
        DatagramSocket socket4 = (DatagramSocket)Mockito.mock(DatagramSocket.class);
        InetAddress localhost = InetAddress.getLocalHost();
        InetSocketAddress socketAddress = new InetSocketAddress(localhost, 2);
        Mockito.when((Object)this.manager.createDatagramSocket(bindingName)).thenReturn((Object)socket1);
        Mockito.when((Object)this.manager.createDatagramSocket(bindingName, (SocketAddress)new InetSocketAddress(1))).thenReturn((Object)socket2);
        Mockito.when((Object)this.manager.createDatagramSocket(bindingName, (SocketAddress)socketAddress)).thenReturn((Object)socket3);
        Mockito.when((Object)this.manager.createDatagramSocket(bindingName, (SocketAddress)new InetSocketAddress(localhost, 1))).thenReturn((Object)socket4);
        DatagramSocket result1 = this.subject.createDatagramSocket(serviceName);
        DatagramSocket result2 = this.subject.createDatagramSocket(serviceName, 1);
        DatagramSocket result3 = this.subject.createDatagramSocket(serviceName, (SocketAddress)socketAddress);
        DatagramSocket result4 = this.subject.createDatagramSocket(serviceName, 1, localhost);
        Assert.assertSame((Object)socket1, (Object)result1);
        Assert.assertSame((Object)socket2, (Object)result2);
        Assert.assertSame((Object)socket3, (Object)result3);
        Assert.assertSame((Object)socket4, (Object)result4);
    }

    @Test
    public void createMulticastSocket() throws IOException {
        this.createMulticastSocket("known-service", "binding");
        this.createMulticastSocket("unknown-service", "unknown-service");
    }

    private void createMulticastSocket(String serviceName, String bindingName) throws IOException {
        MulticastSocket socket1 = (MulticastSocket)Mockito.mock(MulticastSocket.class);
        MulticastSocket socket2 = (MulticastSocket)Mockito.mock(MulticastSocket.class);
        MulticastSocket socket3 = (MulticastSocket)Mockito.mock(MulticastSocket.class);
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLocalHost(), 1);
        Mockito.when((Object)this.manager.createMulticastSocket(bindingName)).thenReturn((Object)socket1);
        Mockito.when((Object)this.manager.createMulticastSocket(bindingName, (SocketAddress)new InetSocketAddress(1))).thenReturn((Object)socket2);
        Mockito.when((Object)this.manager.createMulticastSocket(bindingName, (SocketAddress)address)).thenReturn((Object)socket3);
        MulticastSocket result1 = this.subject.createMulticastSocket(serviceName);
        MulticastSocket result2 = this.subject.createMulticastSocket(serviceName, 1);
        MulticastSocket result3 = this.subject.createMulticastSocket(serviceName, (SocketAddress)address);
        Assert.assertSame((Object)socket1, (Object)result1);
        Assert.assertSame((Object)socket2, (Object)result2);
        Assert.assertSame((Object)socket3, (Object)result3);
    }

    @Test
    public void closeSocket() throws IOException {
        Socket socket = (Socket)Mockito.mock(Socket.class);
        this.subject.close(socket);
        ((Socket)Mockito.verify((Object)socket)).close();
    }

    @Test
    public void closeServerSocket() throws IOException {
        ServerSocket socket = (ServerSocket)Mockito.mock(ServerSocket.class);
        this.subject.close(socket);
        ((ServerSocket)Mockito.verify((Object)socket)).close();
    }

    @Test
    public void closeDatagramSocket() {
        DatagramSocket socket = (DatagramSocket)Mockito.mock(DatagramSocket.class);
        this.subject.close(socket);
        ((DatagramSocket)Mockito.verify((Object)socket)).close();
    }

    @Test
    public void closeMulticastSocket() {
        MulticastSocket socket = (MulticastSocket)Mockito.mock(MulticastSocket.class);
        this.subject.close((DatagramSocket)socket);
        ((MulticastSocket)Mockito.verify((Object)socket)).close();
    }
}

